/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.easybuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.pitan76.mcpitanlib.api.CommonModInitializer;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemBarColorArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemBarStepArgs;
import net.pitan76.mcpitanlib.api.event.item.ItemUseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnEntityEvent;
import net.pitan76.mcpitanlib.api.item.CompatFoodComponent;
import net.pitan76.mcpitanlib.api.item.CreativeTabBuilder;
import net.pitan76.mcpitanlib.api.item.ExtendItem;
import net.pitan76.mcpitanlib.api.item.v2.ItemSettingsBuilder;
import net.pitan76.mcpitanlib.api.registry.v2.CompatRegistryV2;
import net.pitan76.mcpitanlib.api.tag.item.RepairIngredientTag;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.CompatRarity;
import net.pitan76.mcpitanlib.api.util.StackActionResult;
import net.pitan76.mcpitanlib.midohra.easybuilder.built.BuiltItem;
import net.pitan76.mcpitanlib.midohra.item.ItemGroupWrapper;
import net.pitan76.mcpitanlib.midohra.item.ItemWrapper;
import net.pitan76.mcpitanlib.midohra.item.SupplierItemWrapper;

public class ItemBuilder {
    public ItemSettingsBuilder settingsBuilder;
    public Function<ItemUseEvent, StackActionResult> onRightClick;
    public Function<ItemUseOnBlockEvent, CompatActionResult> onRightClickOnBlock;
    public Function<ItemUseOnEntityEvent, CompatActionResult> onRightClickOnEntity;
    public Consumer<ItemAppendTooltipEvent> onAppendTooltip;
    public Function<ItemBarColorArgs, Integer> onItemBarColor;
    public Function<ItemBarStepArgs, Integer> onItemBarStep;
    private final List<TextComponent> tooltip = new ArrayList<TextComponent>();

    public ItemBuilder(ItemSettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    public ItemBuilder(CompatIdentifier id) {
        this(new ItemSettingsBuilder(id));
    }

    public static ItemBuilder of(CompatIdentifier id) {
        return new ItemBuilder(id);
    }

    public static ItemBuilder of(ItemSettingsBuilder settingsBuilder) {
        return new ItemBuilder(settingsBuilder);
    }

    public SupplierItemWrapper build(CompatRegistryV2 registry) {
        if (this.settingsBuilder.id == null) {
            throw new IllegalStateException("Item id is not set. hint: use build(CompatRegistryV2, CompatIdentifier)");
        }
        Supplier<ExtendItem> result = registry.registerExtendItem(this.settingsBuilder.id, () -> new BuiltItem(this));
        return SupplierItemWrapper.of(result::get);
    }

    public SupplierItemWrapper build(CompatRegistryV2 registry, CompatIdentifier id) {
        Supplier<ExtendItem> result = registry.registerExtendItem(this.settingsBuilder.id, () -> new BuiltItem(this, id));
        return SupplierItemWrapper.of(result::get);
    }

    public SupplierItemWrapper build(CommonModInitializer initializer) {
        return this.build(initializer.registry);
    }

    public SupplierItemWrapper build(CommonModInitializer initializer, CompatIdentifier id) {
        return this.build(initializer.registry, id);
    }

    public ItemBuilder maxCount(int maxCount) {
        this.settingsBuilder.maxCount(maxCount);
        return this;
    }

    public ItemBuilder maxDamage(int maxDamage) {
        this.settingsBuilder.maxDamage(maxDamage);
        return this;
    }

    public ItemBuilder maxDamageIfAbsent(int maxDamage) {
        this.settingsBuilder.maxDamageIfAbsent(maxDamage);
        return this;
    }

    public ItemBuilder food(CompatFoodComponent foodComponent) {
        this.settingsBuilder.foodComponent(foodComponent);
        return this;
    }

    public ItemBuilder recipeRemainder(ItemWrapper recipeRemainder) {
        this.settingsBuilder.recipeRemainder(recipeRemainder);
        return this;
    }

    public ItemBuilder enchantability(int enchantability) {
        this.settingsBuilder.enchantability(enchantability);
        return this;
    }

    public ItemBuilder repairable(CompatIdentifier repairIngredientTag) {
        this.settingsBuilder.repairable(repairIngredientTag);
        return this;
    }

    public ItemBuilder repairable(RepairIngredientTag repairIngredientTag) {
        this.settingsBuilder.repairable(repairIngredientTag);
        return this;
    }

    public ItemBuilder rarity(CompatRarity rarity) {
        this.settingsBuilder.rarity(rarity);
        return this;
    }

    public ItemBuilder group(ItemGroupWrapper itemGroup) {
        this.settingsBuilder.addGroup(itemGroup);
        return this;
    }

    public ItemBuilder group(CreativeTabBuilder itemGroup) {
        this.settingsBuilder.addGroup(itemGroup);
        return this;
    }

    public ItemBuilder onRightClick(Function<ItemUseEvent, StackActionResult> onRightClick) {
        this.onRightClick = onRightClick;
        return this;
    }

    public ItemBuilder onRightClickOnBlock(Function<ItemUseOnBlockEvent, CompatActionResult> onRightClickOnBlock) {
        this.onRightClickOnBlock = onRightClickOnBlock;
        return this;
    }

    public ItemBuilder onRightClickOnEntity(Function<ItemUseOnEntityEvent, CompatActionResult> onRightClickOnEntity) {
        this.onRightClickOnEntity = onRightClickOnEntity;
        return this;
    }

    public ItemBuilder onAppendTooltip(Consumer<ItemAppendTooltipEvent> onAppendTooltip) {
        this.onAppendTooltip = onAppendTooltip;
        return this;
    }

    public ItemBuilder onItemBarColor(Function<ItemBarColorArgs, Integer> onItemBarColor) {
        this.onItemBarColor = onItemBarColor;
        return this;
    }

    public ItemBuilder onItemBarStep(Function<ItemBarStepArgs, Integer> onItemBarStep) {
        this.onItemBarStep = onItemBarStep;
        return this;
    }

    public ItemBuilder addTooltip(TextComponent text) {
        this.onAppendTooltip = this.tooltip.isEmpty() ? e -> e.getTooltip().add(text.getText()) : e -> {
            for (TextComponent t : this.tooltip) {
                e.getTooltip().add(t.getText());
            }
            e.getTooltip().add(text.getText());
        };
        this.tooltip.add(text);
        return this;
    }

    public ItemBuilder write(ItemBuilder copy) {
        copy.settingsBuilder = this.settingsBuilder;
        copy.onRightClick = this.onRightClick;
        copy.onRightClickOnBlock = this.onRightClickOnBlock;
        copy.onRightClickOnEntity = this.onRightClickOnEntity;
        copy.onAppendTooltip = this.onAppendTooltip;
        copy.onItemBarColor = this.onItemBarColor;
        copy.onItemBarStep = this.onItemBarStep;
        return copy;
    }

    public ItemBuilder copy(ItemSettingsBuilder builder) {
        return this.write(new ItemBuilder(builder));
    }

    public ItemBuilder copy() {
        return this.copy(this.settingsBuilder.copy());
    }
}

