/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.tag;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.pitan76.mcpitanlib.api.util.BlockUtil;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.EntityTypeUtil;
import net.pitan76.mcpitanlib.api.util.FluidUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;

public class TagKey<T> {
    private final net.minecraft.tags.TagKey<T> tagKey;

    @Deprecated
    public TagKey(net.minecraft.tags.TagKey<T> tagKey) {
        this.tagKey = tagKey;
    }

    public static TagKey<?> create(Type type, ResourceLocation identifier) {
        return switch (type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new TagKey(net.minecraft.tags.TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)identifier));
            case 1 -> new TagKey(net.minecraft.tags.TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)identifier));
            case 2 -> new TagKey(net.minecraft.tags.TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)identifier));
            case 3 -> new TagKey(net.minecraft.tags.TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)identifier));
        };
    }

    public static TagKey<?> create(Type type, CompatIdentifier id) {
        return TagKey.create(type, id.toMinecraft());
    }

    @Deprecated
    public net.minecraft.tags.TagKey<T> getTagKey() {
        return this.tagKey;
    }

    public boolean isOf(T value) {
        if (value instanceof Item) {
            return this.getTagKey() == net.minecraft.tags.TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ItemUtil.toID((Item)value));
        }
        if (value instanceof Block) {
            return this.getTagKey() == net.minecraft.tags.TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BlockUtil.toID((Block)value));
        }
        if (value instanceof Fluid) {
            return this.getTagKey() == net.minecraft.tags.TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)FluidUtil.toID((Fluid)value));
        }
        if (value instanceof EntityType) {
            return this.getTagKey() == net.minecraft.tags.TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)EntityTypeUtil.toID((EntityType)value));
        }
        return Holder.direct(value).is(this.getTagKey());
    }

    public static enum Type {
        BLOCK,
        ITEM,
        FLUID,
        ENTITY_TYPE;

    }
}

