/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PersistentStateUtil {
    public static <T extends SavedData> T getOrCreate(DimensionDataStorage manager, String id, Supplier<T> supplier, Function<CompoundTag, T> function) {
        SavedData.Factory type = new SavedData.Factory(supplier, function, DataFixTypes.LEVEL);
        return (T)manager.computeIfAbsent(type, id);
    }

    public static DimensionDataStorage getManagerFromServer(MinecraftServer server) {
        return server.getLevel(Level.OVERWORLD).getDataStorage();
    }

    public static DimensionDataStorage getManagerFromWorld(ServerLevel world) {
        return world.getDataStorage();
    }

    public static void markDirty(SavedData state) {
        state.setDirty();
    }
}

