/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.collection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.pitan76.mcpitanlib.api.gui.inventory.IInventory;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackList
extends NonNullList<net.minecraft.world.item.ItemStack> {
    public ItemStackList(List<net.minecraft.world.item.ItemStack> delegate, @Nullable net.minecraft.world.item.ItemStack initialElement) {
        super(delegate, (Object)initialElement);
    }

    public static ItemStackList of() {
        return new ItemStackList(Lists.newArrayList(), ItemStackUtil.empty());
    }

    public static ItemStackList ofSize(int size) {
        return ItemStackList.ofSize(size, ItemStackUtil.empty());
    }

    public static ItemStackList ofSize(int size, net.minecraft.world.item.ItemStack defaultStack) {
        Validate.notNull((Object)defaultStack);
        Object[] objects = new net.minecraft.world.item.ItemStack[size];
        Arrays.fill(objects, defaultStack);
        return new ItemStackList(Arrays.asList(objects), defaultStack);
    }

    public static ItemStackList copyOf(net.minecraft.world.item.ItemStack defaultStack, net.minecraft.world.item.ItemStack ... stacks) {
        return new ItemStackList(Arrays.asList(stacks), defaultStack);
    }

    public static Container toInventory(NonNullList<net.minecraft.world.item.ItemStack> list) {
        return IInventory.of(list);
    }

    public static NonNullList<net.minecraft.world.item.ItemStack> toDefaultedList(Container inventory) {
        NonNullList list = NonNullList.withSize((int)inventory.getContainerSize(), (Object)ItemStackUtil.empty());
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            list.set(i, (Object)inventory.getItem(i));
        }
        return list;
    }

    public static ItemStackList fromInventory(Container inventory) {
        return new ItemStackList((List<net.minecraft.world.item.ItemStack>)ItemStackList.toDefaultedList(inventory), ItemStackUtil.empty());
    }

    public Container toInventory() {
        return ItemStackList.toInventory(this);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> defaultedList() {
        return this;
    }

    public static ItemStackList of(NonNullList<net.minecraft.world.item.ItemStack> defaultedList) {
        ItemStackList stacks = ItemStackList.ofSize(defaultedList.size());
        for (int i = 0; i < defaultedList.size(); ++i) {
            stacks.set(i, (net.minecraft.world.item.ItemStack)defaultedList.get(i));
        }
        return stacks;
    }

    public static ItemStackList of(net.minecraft.world.item.ItemStack stack) {
        return ItemStackList.ofSize(1, stack);
    }

    public List<ItemStack> toMidohra() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            net.minecraft.world.item.ItemStack stack = (net.minecraft.world.item.ItemStack)iterator.next();
            stacks.add(ItemStack.of(stack));
        }
        return stacks;
    }

    @NotNull
    public ItemStack getAsMidohra(int index) {
        return ItemStack.of((net.minecraft.world.item.ItemStack)this.get(index));
    }

    public ItemStack getFirstAsMidohra() {
        return this.getAsMidohra(0);
    }

    public ItemStack getLastAsMidohra() {
        return this.getAsMidohra(this.size() - 1);
    }

    public boolean add(ItemStack stack) {
        return this.add(stack.toMinecraft());
    }

    public boolean addAll(List<ItemStack> stacks) {
        boolean changed = false;
        for (ItemStack stack : stacks) {
            changed |= this.add(stack);
        }
        return changed;
    }

    public boolean addAll(ItemStack ... stacks) {
        return this.addAll(Arrays.asList(stacks));
    }

    public boolean remove(ItemStack stack) {
        return this.remove(stack.toMinecraft());
    }

    public boolean removeAll(List<ItemStack> stacks) {
        boolean changed = false;
        for (ItemStack stack : stacks) {
            changed |= this.remove(stack);
        }
        return changed;
    }

    public boolean removeAll(ItemStack ... stacks) {
        return this.removeAll(Arrays.asList(stacks));
    }

    public boolean contains(ItemStack stack) {
        return this.contains(stack.toMinecraft());
    }

    public boolean containsAll(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (this.contains(stack)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ItemStack ... stacks) {
        return this.containsAll(Arrays.asList(stacks));
    }

    public boolean containsAny(List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!this.contains(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(ItemStack ... stacks) {
        return this.containsAny(Arrays.asList(stacks));
    }

    public boolean equals(List<ItemStack> stacks) {
        if (this.size() != stacks.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((net.minecraft.world.item.ItemStack)this.get(i)).equals(stacks.get(i).toMinecraft())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(ItemStack ... stacks) {
        return this.equals(Arrays.asList(stacks));
    }

    public static ItemStackList of(List<ItemStack> stacks) {
        ItemStackList list = ItemStackList.ofSize(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            list.set(i, stacks.get(i).toMinecraft());
        }
        return list;
    }

    public static ItemStackList of(ItemStack ... stacks) {
        return ItemStackList.of(Arrays.asList(stacks));
    }

    public static ItemStackList of(ItemStack stack) {
        return ItemStackList.of(stack, 1);
    }

    public static ItemStackList of(ItemStack stack, int size) {
        return ItemStackList.ofSize(size, stack.toMinecraft());
    }

    public static ItemStackList of2(List<net.minecraft.world.item.ItemStack> stacks) {
        ItemStackList list = ItemStackList.ofSize(stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            list.set(i, stacks.get(i));
        }
        return list;
    }
}

