/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class ItemEntityUtil {
    public static ItemEntity create(Level world, double x, double y, double z, ItemStack stack) {
        return new ItemEntity(world, x, y, z, stack);
    }

    public static ItemEntity create(Level world, BlockPos pos, ItemStack stack) {
        return ItemEntityUtil.create(world, pos.getX(), pos.getY(), pos.getZ(), stack);
    }

    public static ItemEntity create(Level world, Vec3 pos, ItemStack stack) {
        return ItemEntityUtil.create(world, pos.x, pos.y, pos.z, stack);
    }

    public static ItemEntity create(Level world, double x, double y, double z, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        ItemEntity itemEntity = ItemEntityUtil.create(world, x, y, z, stack);
        ItemEntityUtil.setVelocity(itemEntity, velocityX, velocityY, velocityZ);
        return itemEntity;
    }

    public static void setVelocity(ItemEntity itemEntity, double velocityX, double velocityY, double velocityZ) {
        itemEntity.setDeltaMovement(velocityX, velocityY, velocityZ);
    }

    public static void setVelocity(ItemEntity itemEntity, Vec3 vec3d) {
        itemEntity.setDeltaMovement(vec3d);
    }

    public static void setPickupDelay(ItemEntity itemEntity, int pickupDelay) {
        itemEntity.setPickUpDelay(pickupDelay);
    }

    public static void setToDefaultPickupDelay(ItemEntity itemEntity) {
        itemEntity.setDefaultPickUpDelay();
    }

    public static ItemStack getStack(ItemEntity entity) {
        return entity.getItem();
    }

    public static List<ItemEntity> getEntities(Level world, AABB box) {
        return WorldUtil.getEntitiesByType(world, EntityType.ITEM, box);
    }

    public static ItemEntity createWithSpawn(Level world, ItemStack stack, double x, double y, double z) {
        ItemEntity itemEntity = ItemEntityUtil.create(world, x, y, z, stack);
        ItemEntityUtil.setToDefaultPickupDelay(itemEntity);
        ItemEntityUtil.setVelocity(itemEntity, 0.0, 0.0, 0.0);
        WorldUtil.spawnEntity(world, (Entity)itemEntity);
        return itemEntity;
    }

    public static ItemEntity createWithSpawn(Level world, ItemStack stack, BlockPos pos) {
        return ItemEntityUtil.createWithSpawn(world, stack, pos.getX(), pos.getY(), pos.getZ());
    }
}

