/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.entity;

import java.util.Collections;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;

public class ServerPlayerUtil {
    public static boolean teleport(ServerPlayer serverPlayerEntity, ServerLevel serverWorld, double x, double y, double z, float yaw, float pitch, boolean resetCamera) {
        if (resetCamera) {
            serverPlayerEntity.stopRiding();
            serverPlayerEntity.setCamera((Entity)serverPlayerEntity);
        }
        return serverPlayerEntity.teleportTo(serverWorld, x, y, z, Collections.emptySet(), yaw, pitch);
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, ServerLevel serverWorld, double x, double y, double z, float yaw, float pitch) {
        serverPlayerEntity.teleportTo(serverWorld, x, y, z, yaw, pitch);
        return true;
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, ServerLevel serverWorld, double x, double y, double z) {
        return ServerPlayerUtil.teleport(serverPlayerEntity, serverWorld, x, y, z, serverPlayerEntity.getYRot(), serverPlayerEntity.getXRot());
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, ServerWorld serverWorld, double x, double y, double z, float yaw, float pitch, boolean resetCamera) {
        return ServerPlayerUtil.teleport(serverPlayerEntity, serverWorld.getRaw(), x, y, z, yaw, pitch, resetCamera);
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, ServerWorld serverWorld, double x, double y, double z, float yaw, float pitch) {
        return ServerPlayerUtil.teleport(serverPlayerEntity, serverWorld, x, y, z, yaw, pitch, false);
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, ServerWorld serverWorld, double x, double y, double z) {
        return ServerPlayerUtil.teleport(serverPlayerEntity, serverWorld, x, y, z, serverPlayerEntity.getYRot(), serverPlayerEntity.getXRot());
    }

    public static boolean teleport(Player player, ServerWorld serverWorld, double x, double y, double z, float yaw, float pitch, boolean resetCamera) {
        Optional<ServerPlayer> optionalServerPlayer = player.getServerPlayer();
        if (!optionalServerPlayer.isPresent()) {
            return false;
        }
        return ServerPlayerUtil.teleport(optionalServerPlayer.get(), serverWorld, x, y, z, yaw, pitch, resetCamera);
    }

    public static boolean teleport(Player player, ServerWorld serverWorld, double x, double y, double z, float yaw, float pitch) {
        return ServerPlayerUtil.teleport(player, serverWorld, x, y, z, yaw, pitch, false);
    }

    public static boolean teleport(Player player, ServerWorld serverWorld, double x, double y, double z) {
        return ServerPlayerUtil.teleport(player, serverWorld, x, y, z, player.getYaw(), player.getPitch());
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, double x, double y, double z, boolean particleEffects) {
        return serverPlayerEntity.randomTeleport(x, y, z, particleEffects);
    }

    public static boolean teleport(ServerPlayer serverPlayerEntity, double x, double y, double z) {
        return ServerPlayerUtil.teleport(serverPlayerEntity, x, y, z, false);
    }

    public static boolean teleport(Player player, double x, double y, double z, boolean particleEffects) {
        Optional<ServerPlayer> optionalServerPlayer = player.getServerPlayer();
        if (!optionalServerPlayer.isPresent()) {
            return false;
        }
        return ServerPlayerUtil.teleport(optionalServerPlayer.get(), x, y, z, particleEffects);
    }

    public static boolean teleport(Player player, double x, double y, double z) {
        return ServerPlayerUtil.teleport(player, x, y, z, false);
    }

    public static void playSound(ServerPlayer serverPlayerEntity, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        serverPlayerEntity.playNotifySound(soundEvent.get(), category.get(), volume, pitch);
    }

    public static void playSound(ServerPlayer serverPlayerEntity, CompatSoundEvent soundEvent, float volume, float pitch) {
        serverPlayerEntity.playSound(soundEvent.get(), volume, pitch);
    }

    public static void playSound(ServerPlayer serverPlayerEntity, CompatSoundEvent soundEvent) {
        serverPlayerEntity.playSound(soundEvent.get(), 1.0f, 1.0f);
    }

    public static void playSound(Player player, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        Optional<ServerPlayer> optionalServerPlayer = player.getServerPlayer();
        if (!optionalServerPlayer.isPresent()) {
            return;
        }
        ServerPlayerUtil.playSound(optionalServerPlayer.get(), soundEvent, category, volume, pitch);
    }

    public static void playSound(Player player, CompatSoundEvent soundEvent, float volume, float pitch) {
        Optional<ServerPlayer> optionalServerPlayer = player.getServerPlayer();
        if (!optionalServerPlayer.isPresent()) {
            return;
        }
        ServerPlayerUtil.playSound(optionalServerPlayer.get(), soundEvent, volume, pitch);
    }

    public static void playSound(Player player, CompatSoundEvent soundEvent) {
        Optional<ServerPlayer> optionalServerPlayer = player.getServerPlayer();
        if (!optionalServerPlayer.isPresent()) {
            return;
        }
        ServerPlayerUtil.playSound(optionalServerPlayer.get(), soundEvent);
    }
}

