/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.mixin;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.pitan76.mcpitanlib.api.block.ExtendBlockProvider;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.event.block.BlockBreakEvent;
import net.pitan76.mcpitanlib.api.event.block.BlockPlacedEvent;
import net.pitan76.mcpitanlib.api.event.block.PickStackEvent;
import net.pitan76.mcpitanlib.api.event.block.PlacementStateArgs;
import net.pitan76.mcpitanlib.api.event.block.result.BlockBreakResult;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.event.v1.listener.BlockBreakTask;
import net.pitan76.mcpitanlib.api.event.v1.listener.BlockPlacedTask;
import net.pitan76.mcpitanlib.api.event.v2.BlockEventRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.class})
public class BlockMixin {
    @Inject(method={"setPlacedBy(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$onPlaced(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, CallbackInfo ci) {
        if (!BlockEventRegistry.ON_PLACED.isEmpty()) {
            int maxPriority;
            for (int p = maxPriority = BlockEventRegistry.ON_PLACED.getMaxPriority(); p >= 0; --p) {
                for (BlockPlacedTask listener : BlockEventRegistry.ON_PLACED.getListenersAsList(p)) {
                    listener.onPlaced(new BlockPlacedEvent(world, pos, state, placer, stack));
                }
            }
        }
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.onPlaced(new BlockPlacedEvent(world, pos, state, placer, stack), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"playerWillDestroy(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$onBreak(Level world, BlockPos pos, BlockState state, Player player, CallbackInfoReturnable<BlockState> cir) {
        if (!BlockEventRegistry.ON_BREAK.isEmpty()) {
            int maxPriority;
            BlockState newState = state;
            for (int p = maxPriority = BlockEventRegistry.ON_BREAK.getMaxPriority(); p >= 0; --p) {
                for (BlockBreakTask listener : BlockEventRegistry.ON_BREAK.getListenersAsList(p)) {
                    newState = listener.onBreak((BlockBreakEvent)new BlockBreakEvent((Level)world, (BlockPos)pos, (BlockState)newState, (Player)player)).state;
                }
            }
            if (newState != state) {
                cir.setReturnValue((Object)newState);
                state = newState;
            }
        }
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            BlockBreakResult returnValue = provider.onBreak(new BlockBreakEvent(world, pos, state, player), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue.getState());
            }
        }
    }

    @Inject(method={"getCloneItemStack(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getPickStack(LevelReader world, BlockPos pos, BlockState state, CallbackInfoReturnable<ItemStack> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            ItemStack returnValue = provider.getPickStack(new PickStackEvent(world, pos, state), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"createBlockStateDefinition(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$appendProperties(StateDefinition.Builder<Block, BlockState> builder, CallbackInfo ci) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.appendProperties(new AppendPropertiesArgs(builder), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"getStateForPlacement(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$getPlacementState(BlockPlaceContext ctx, CallbackInfoReturnable<BlockState> cir) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            BlockState returnValue = provider.getPlacementState(new PlacementStateArgs(ctx), options);
            if (options.cancel && returnValue != null) {
                cir.setReturnValue((Object)returnValue);
            }
        }
    }

    @Inject(method={"appendHoverText(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/BlockGetter;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void mcpitanlib$appendTooltip(ItemStack stack, BlockGetter world, List<Component> tooltip, TooltipFlag context, CallbackInfo ci) {
        if (this instanceof ExtendBlockProvider) {
            ExtendBlockProvider provider = (ExtendBlockProvider)((Object)this);
            ExtendBlockProvider.Options options = new ExtendBlockProvider.Options();
            provider.appendTooltip(new ItemAppendTooltipEvent(stack, world, tooltip, context), options);
            if (options.cancel) {
                ci.cancel();
            }
        }
    }
}

