/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.easybuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_265;
import net.pitan76.mcpitanlib.api.CommonModInitializer;
import net.pitan76.mcpitanlib.api.block.CompatBlockRenderType;
import net.pitan76.mcpitanlib.api.block.CompatibleMaterial;
import net.pitan76.mcpitanlib.api.block.ExtendBlock;
import net.pitan76.mcpitanlib.api.block.args.RenderTypeArgs;
import net.pitan76.mcpitanlib.api.block.args.v2.CollisionShapeEvent;
import net.pitan76.mcpitanlib.api.block.args.v2.OutlineShapeEvent;
import net.pitan76.mcpitanlib.api.block.args.v2.PlacementStateArgs;
import net.pitan76.mcpitanlib.api.block.args.v2.StateForNeighborUpdateArgs;
import net.pitan76.mcpitanlib.api.block.v2.BlockSettingsBuilder;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.event.block.BlockUseEvent;
import net.pitan76.mcpitanlib.api.event.block.DroppedStacksArgs;
import net.pitan76.mcpitanlib.api.event.block.StateReplacedEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemAppendTooltipEvent;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.registry.result.RegistryResult;
import net.pitan76.mcpitanlib.api.registry.v2.CompatRegistryV2;
import net.pitan76.mcpitanlib.api.sound.CompatBlockSoundGroup;
import net.pitan76.mcpitanlib.api.text.TextComponent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.color.CompatDyeColor;
import net.pitan76.mcpitanlib.api.util.color.CompatMapColor;
import net.pitan76.mcpitanlib.api.util.item.ItemUtil;
import net.pitan76.mcpitanlib.core.datafixer.Pair;
import net.pitan76.mcpitanlib.midohra.block.BlockState;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.SupplierBlockWrapper;
import net.pitan76.mcpitanlib.midohra.easybuilder.built.BuiltBlock;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import net.pitan76.mcpitanlib.midohra.item.SupplierItemWrapper;
import net.pitan76.mcpitanlib.midohra.util.shape.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockBuilder {
    public BlockSettingsBuilder settingsBuilder;
    public Function<BlockUseEvent, CompatActionResult> onRightClick;
    public Consumer<StateReplacedEvent> onStateReplaced;
    public Consumer<ItemAppendTooltipEvent> onAppendTooltip;
    public Consumer<AppendPropertiesArgs> onAppendProperties;
    public BlockState defaultState;
    public BiConsumer<BlockWrapper, BlockBuilder> onInit;
    public Function<OutlineShapeEvent, class_265> onOutlineShape;
    public Function<CollisionShapeEvent, class_265> onCollisionShape;
    public Function<RenderTypeArgs, CompatBlockRenderType> onRenderType;
    public Function<PlacementStateArgs, @Nullable BlockState> onPlacementState;
    public Function<StateForNeighborUpdateArgs, BlockState> onStateForNeighborUpdate;
    public Function<DroppedStacksArgs, List<class_1799>> onDroppedStacks;
    private final List<TextComponent> tooltip = new ArrayList<TextComponent>();

    public BlockBuilder(BlockSettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
    }

    public BlockBuilder(CompatIdentifier id) {
        this(new BlockSettingsBuilder(id));
    }

    public static BlockBuilder of(CompatIdentifier id) {
        return new BlockBuilder(id);
    }

    public static BlockBuilder of(BlockSettingsBuilder settingsBuilder) {
        return new BlockBuilder(settingsBuilder);
    }

    public SupplierBlockWrapper build(CompatRegistryV2 registry) {
        if (this.settingsBuilder.id == null) {
            throw new IllegalStateException("Block id is not set. hint: use build(CompatRegistryV2, CompatIdentifier)");
        }
        Supplier<ExtendBlock> result = registry.registerExtendBlock(this.settingsBuilder.id, () -> new BuiltBlock(this));
        return SupplierBlockWrapper.of(result::get);
    }

    public SupplierBlockWrapper build(CompatRegistryV2 registry, CompatIdentifier id) {
        Supplier<ExtendBlock> result = registry.registerExtendBlock(id, () -> new BuiltBlock(this, id));
        return SupplierBlockWrapper.of(result::get);
    }

    public SupplierBlockWrapper build(CommonModInitializer initializer) {
        return this.build(initializer.registry);
    }

    public SupplierBlockWrapper build(CommonModInitializer initializer, CompatIdentifier id) {
        return this.build(initializer.registry, id);
    }

    public Pair<SupplierBlockWrapper, SupplierItemWrapper> buildWithItem(CompatRegistryV2 registry, CompatibleItemSettings settings) {
        SupplierBlockWrapper block = this.build(registry);
        RegistryResult<class_1792> result = registry.registerItem(this.settingsBuilder.id, () -> ItemUtil.create(block.get(), settings));
        return Pair.of(block, SupplierItemWrapper.of(result::get));
    }

    public Pair<SupplierBlockWrapper, SupplierItemWrapper> buildWithItem(CompatRegistryV2 registry, CompatIdentifier id, CompatibleItemSettings settings) {
        SupplierBlockWrapper block = this.build(registry, id);
        RegistryResult<class_1792> result = registry.registerItem(id, () -> ItemUtil.create(block.get(), settings.setId(id)));
        return Pair.of(block, SupplierItemWrapper.of(result::get));
    }

    public Pair<SupplierBlockWrapper, SupplierItemWrapper> buildWithItem(CommonModInitializer initializer, CompatibleItemSettings settings) {
        return this.buildWithItem(initializer.registry, settings);
    }

    public Pair<SupplierBlockWrapper, SupplierItemWrapper> buildWithItem(CommonModInitializer initializer, CompatIdentifier id, CompatibleItemSettings settings) {
        return this.buildWithItem(initializer.registry, id, settings);
    }

    public BlockBuilder material(CompatibleMaterial material) {
        this.settingsBuilder.material(material);
        return this;
    }

    public BlockBuilder sounds(CompatBlockSoundGroup sounds) {
        this.settingsBuilder.sounds(sounds);
        return this;
    }

    public BlockBuilder strength(float hardness, float resistance) {
        this.settingsBuilder.strength(hardness, resistance);
        return this;
    }

    public BlockBuilder strength(float hardness) {
        this.settingsBuilder.hardness(hardness);
        return this;
    }

    public BlockBuilder resistance(float resistance) {
        this.settingsBuilder.resistance(resistance);
        return this;
    }

    public BlockBuilder mapColor(CompatMapColor color) {
        this.settingsBuilder.mapColor(color);
        return this;
    }

    public BlockBuilder mapColor(CompatDyeColor color) {
        this.settingsBuilder.dyeColor(color);
        return this;
    }

    public BlockBuilder luminance(ToIntFunction<BlockState> luminance) {
        this.settingsBuilder.luminance(luminance);
        return this;
    }

    public BlockBuilder requiresTool() {
        this.settingsBuilder.requiresTool();
        return this;
    }

    public BlockBuilder dropsNothing() {
        this.settingsBuilder.dropsNothing();
        return this;
    }

    public BlockBuilder onRightClick(Function<BlockUseEvent, CompatActionResult> onRightClick) {
        this.onRightClick = onRightClick;
        return this;
    }

    public BlockBuilder onStateReplaced(Consumer<StateReplacedEvent> onStateReplaced) {
        this.onStateReplaced = onStateReplaced;
        return this;
    }

    public BlockBuilder onAppendTooltip(Consumer<ItemAppendTooltipEvent> onAppendTooltip) {
        this.onAppendTooltip = onAppendTooltip;
        return this;
    }

    public BlockBuilder onAppendProperties(Consumer<AppendPropertiesArgs> onAppendProperties) {
        this.onAppendProperties = onAppendProperties;
        return this;
    }

    public BlockBuilder onOutlineShape(Function<OutlineShapeEvent, VoxelShape> onOutlineShape) {
        return this.onOutlineShapeRaw(e -> ((VoxelShape)onOutlineShape.apply((OutlineShapeEvent)e)).raw());
    }

    public BlockBuilder onCollisionShape(Function<CollisionShapeEvent, VoxelShape> onCollisionShape) {
        return this.onCollisionShapeRaw(e -> ((VoxelShape)onCollisionShape.apply((CollisionShapeEvent)e)).raw());
    }

    public BlockBuilder onOutlineShapeRaw(Function<OutlineShapeEvent, class_265> onOutlineShape) {
        this.onOutlineShape = onOutlineShape;
        return this;
    }

    public BlockBuilder onCollisionShapeRaw(Function<CollisionShapeEvent, class_265> onCollisionShape) {
        this.onCollisionShape = onCollisionShape;
        return this;
    }

    public BlockBuilder onRenderType(Function<RenderTypeArgs, CompatBlockRenderType> onRenderType) {
        this.onRenderType = onRenderType;
        return this;
    }

    public BlockBuilder onPlacementState(Function<PlacementStateArgs, @Nullable BlockState> onPlacementState) {
        this.onPlacementState = onPlacementState;
        return this;
    }

    public BlockBuilder onStateForNeighborUpdate(Function<StateForNeighborUpdateArgs, BlockState> onStateForNeighborUpdate) {
        this.onStateForNeighborUpdate = onStateForNeighborUpdate;
        return this;
    }

    public BlockBuilder setOutlineShape(VoxelShape shape) {
        return this.onOutlineShape(e -> shape);
    }

    public BlockBuilder setCollisionShape(VoxelShape shape) {
        return this.onCollisionShape(e -> shape);
    }

    public BlockBuilder setOutlineShape(class_265 shape) {
        return this.onOutlineShapeRaw(e -> shape);
    }

    public BlockBuilder setCollisionShape(class_265 shape) {
        return this.onCollisionShapeRaw(e -> shape);
    }

    public BlockBuilder setRenderType(CompatBlockRenderType renderType) {
        return this.onRenderType(e -> renderType);
    }

    public BlockBuilder onInit(BiConsumer<BlockWrapper, BlockBuilder> onInit) {
        this.onInit = onInit;
        return this;
    }

    public BlockBuilder setDefaultState(BlockState defaultState) {
        this.defaultState = defaultState;
        return this;
    }

    public BlockBuilder addTooltip(TextComponent text) {
        this.onAppendTooltip = this.tooltip.isEmpty() ? e -> e.getTooltip().add(text.getText()) : e -> {
            for (TextComponent t : this.tooltip) {
                e.getTooltip().add(t.getText());
            }
            e.getTooltip().add(text.getText());
        };
        this.tooltip.add(text);
        return this;
    }

    public BlockBuilder onDroppedStacksRaw(Function<DroppedStacksArgs, List<class_1799>> onDroppedStacks) {
        this.onDroppedStacks = onDroppedStacks;
        return this;
    }

    public BlockBuilder onDroppedStacks(Function<DroppedStacksArgs, List<ItemStack>> onDroppedStacks) {
        return this.onDroppedStacksRaw(e -> ((List)onDroppedStacks.apply((DroppedStacksArgs)e)).stream().map(ItemStack::toMinecraft).toList());
    }

    public BlockBuilder write(BlockBuilder copy) {
        copy.onRightClick = this.onRightClick;
        copy.onStateReplaced = this.onStateReplaced;
        copy.onAppendTooltip = this.onAppendTooltip;
        copy.onAppendProperties = this.onAppendProperties;
        copy.defaultState = this.defaultState;
        copy.onInit = this.onInit;
        copy.onOutlineShape = this.onOutlineShape;
        copy.onCollisionShape = this.onCollisionShape;
        copy.onRenderType = this.onRenderType;
        copy.onPlacementState = this.onPlacementState;
        copy.onStateForNeighborUpdate = this.onStateForNeighborUpdate;
        copy.onDroppedStacks = this.onDroppedStacks;
        return copy;
    }

    public BlockBuilder copy(BlockSettingsBuilder settingsBuilder) {
        return this.write(new BlockBuilder(settingsBuilder));
    }

    public BlockBuilder copy() {
        return this.copy(this.settingsBuilder.copy());
    }
}

