/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.world;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.RegistryLookupUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.recipe.RecipeManager;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;
import net.pitan76.mcpitanlib.midohra.world.ServerWorld;
import net.pitan76.mcpitanlib.midohra.world.WorldAccess;

public class World
extends WorldAccess {
    private final class_1937 world;

    protected World(class_1937 world) {
        super((class_1936)null);
        this.world = world;
    }

    public static World of(class_1937 world) {
        return new World(world);
    }

    public class_1937 getRaw() {
        return this.world;
    }

    public class_1937 toMinecraft() {
        return this.getRaw();
    }

    public void addBlockEntity(BlockEntityWrapper blockEntity) {
        this.addBlockEntity(blockEntity.get());
    }

    public void addBlockEntity(class_2586 blockEntity) {
        this.getRaw().method_8438(blockEntity);
    }

    public void removeBlockEntity(BlockPos pos) {
        this.getRaw().method_8544(pos.toMinecraft());
    }

    public long getTime() {
        return WorldUtil.getTime(this.getRaw());
    }

    public long getTopY() {
        return WorldUtil.getTopY(this.getRaw());
    }

    public long getBottomY() {
        return WorldUtil.getBottomY(this.getRaw());
    }

    public long getDimensionHeight() {
        return WorldUtil.getDimensionHeight(this.getRaw());
    }

    public CompatIdentifier getId() {
        return WorldUtil.getCompatWorldId(this.getRaw());
    }

    public class_3610 getRawFluidState(BlockPos pos) {
        return WorldUtil.getFluidState(this.getRaw(), pos.toMinecraft());
    }

    public Player getPlayerByUUID(UUID uuid) {
        return WorldUtil.getPlayer(this.getRaw(), uuid);
    }

    public List<Player> getPlayers() {
        return WorldUtil.getPlayers(this.getRaw());
    }

    public BlockPos getSpawnPos() {
        return BlockPos.of(WorldUtil.getSpawnPos(this.getRaw()));
    }

    public Optional<World> getWorld(CompatIdentifier id) {
        Optional<class_3218> optional = WorldUtil.getWorld(this.getRaw(), id);
        return optional.map(World::of);
    }

    public Optional<ServerWorld> getServerWorld(CompatIdentifier id) {
        Optional<class_3218> optional = WorldUtil.getWorld(this.getRaw(), id);
        return optional.map(ServerWorld::of);
    }

    public void spawnEntity(class_1297 entity) {
        WorldUtil.spawnEntity(this.getRaw(), entity);
    }

    public void spawnStack(class_1799 stack, BlockPos pos) {
        WorldUtil.spawnStack(this.getRaw(), pos.toMinecraft(), stack);
    }

    public RecipeManager getRecipeManager() {
        return RecipeManager.of(this.getRaw().method_8433());
    }

    @Override
    @Deprecated
    public void playSound(class_1657 playerEntity, class_2338 pos, class_3414 sound, class_3419 category) {
        this.getRaw().method_45447((class_1297)playerEntity, pos, sound, category);
    }

    @Override
    @Deprecated
    public void playSound(class_1657 playerEntity, class_2338 pos, class_3414 sound, class_3419 category, float volume, float pitch) {
        this.getRaw().method_8396((class_1297)playerEntity, pos, sound, category, volume, pitch);
    }

    @Override
    public void playSound(Player player, BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        WorldUtil.playSound(this.getRaw(), player, pos.toMinecraft(), soundEvent, category, volume, pitch);
    }

    @Override
    public void playSound(BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(null, pos, soundEvent, category, 1.0f, 1.0f);
    }

    @Override
    public void playSound(Player player, BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category) {
        this.playSound(player, pos, soundEvent, category, 1.0f, 1.0f);
    }

    @Override
    public void playSound(BlockPos pos, CompatSoundEvent soundEvent, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(null, pos, soundEvent, category, volume, pitch);
    }

    public Optional<ServerWorld> toServerWorld() {
        if (this.getRaw() instanceof class_3218) {
            return Optional.of(ServerWorld.of((class_3218)this.getRaw()));
        }
        return Optional.empty();
    }

    public CompatRegistryLookup getRegistryLookup() {
        return RegistryLookupUtil.getRegistryLookup(this.getRaw());
    }
}

