/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.client.color.CompatBlockColorProvider;
import net.pitan76.mcpitanlib.api.client.registry.neoforge.CompatRegistryClientImpl;
import net.pitan76.mcpitanlib.api.client.render.CompatRenderLayer;
import net.pitan76.mcpitanlib.api.client.render.EntityModelLayerContext;

@OnlyIn(value=Dist.CLIENT)
public class CompatRegistryClient {
    public static <H extends AbstractContainerMenu, S extends Screen> void registerScreen(MenuType<? extends H> type, ScreenFactory<H, S> factory) {
        CompatRegistryClient.registerScreen("mcpitanlib", type, factory);
    }

    public static <H extends AbstractContainerMenu, S extends Screen> void registerScreen(String modId, MenuType<? extends H> type, ScreenFactory<H, S> factory) {
        MenuRegistry.registerScreenFactory(type, factory::create);
    }

    public static <T extends ParticleOptions> void registerParticle(ParticleType<T> type, ParticleProvider<T> factory) {
        ParticleProviderRegistry.register(type, factory);
    }

    public static <T extends ParticleOptions> void registerParticle(ParticleType<T> type, DeferredParticleProvider<T> provider) {
        ParticleProviderRegistry.register(type, spriteSet -> provider.create(new ExtendedSpriteSet(){

            @Override
            public TextureAtlas getAtlas() {
                return spriteSet.getAtlas();
            }

            @Override
            public List<TextureAtlasSprite> getSprites() {
                return spriteSet.getSprites();
            }

            public TextureAtlasSprite get(int age, int maxAge) {
                return spriteSet.get(age, maxAge);
            }

            public TextureAtlasSprite get(RandomSource random) {
                return spriteSet.get(random);
            }
        }));
    }

    public static void registerEntityModelLayer(ModelLayerLocation layer, EntityModelLayerContext context) {
        EntityModelLayerRegistry.register((ModelLayerLocation)layer, () -> LayerDefinition.create((MeshDefinition)context.getData(), (int)context.getWidth(), (int)context.getHeight()));
    }

    public static <T extends Entity> void registerEntityRenderer(Supplier<? extends EntityType<? extends T>> type, EntityRendererProvider<T> provider) {
        EntityRendererRegistry.register(type, provider);
    }

    public static void registryClientSpriteAtlasTexture(ResourceLocation identifier) {
    }

    public static void registryClientSpriteAtlasTexture(TextureAtlasSprite sprite) {
    }

    public static void registryClientSprite(ResourceLocation atlasId, ResourceLocation identifier) {
    }

    public static void registryClientSprite(ResourceLocation atlasId, TextureAtlasSprite sprite) {
    }

    public static <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<T> type, BlockEntityRendererFactory<T> provider) {
        BlockEntityRendererRegistry.register(type, ctx -> provider.create(new BlockEntityRendererFactory.Context(ctx.getBlockEntityRenderDispatcher(), ctx.getBlockRenderDispatcher(), ctx.getItemRenderer(), ctx.getEntityRenderer(), ctx.getModelSet(), ctx.getFont())));
    }

    public static void registerRenderTypeBlock(RenderType layer, Block block) {
        RenderTypeRegistry.register((RenderType)layer, (Block[])new Block[]{block});
    }

    public static void registerRenderTypeFluid(RenderType layer, Fluid fluid) {
        RenderTypeRegistry.register((RenderType)layer, (Fluid[])new Fluid[]{fluid});
    }

    public static void registerCutoutBlock(Block block) {
        CompatRegistryClient.registerRenderTypeBlock(RenderType.cutout(), block);
    }

    public static <T extends BlockEntity> void registerCompatBlockEntityRenderer(BlockEntityType<T> type, BlockEntityRendererFactory<T> provider) {
        BlockEntityRendererRegistry.register(type, ctx -> provider.create(new BlockEntityRendererFactory.Context(ctx.getBlockEntityRenderDispatcher(), ctx.getBlockRenderDispatcher(), ctx.getItemRenderer(), ctx.getEntityRenderer(), ctx.getModelSet(), ctx.getFont())));
    }

    public static void registerRenderTypeBlock(CompatRenderLayer layer, Block block) {
        CompatRegistryClient.registerRenderTypeBlock(layer.layer, block);
    }

    public static void registerRenderTypeFluid(CompatRenderLayer layer, Fluid fluid) {
        CompatRegistryClient.registerRenderTypeFluid(layer.layer, fluid);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerColorProviderBlock(BlockColor provider, Block ... blocks) {
        void var1_1;
        CompatRegistryClientImpl.registerColorProviderBlock(provider, (Block[])var1_1);
    }

    public static void registerColorProviderBlock(CompatBlockColorProvider provider, Block ... blocks) {
        CompatRegistryClient.registerColorProviderBlock((BlockColor)provider, blocks);
    }

    public static interface ScreenFactory<H extends AbstractContainerMenu, S extends Screen> {
        public S create(H var1, Inventory var2, Component var3);
    }

    @FunctionalInterface
    public static interface DeferredParticleProvider<T extends ParticleOptions> {
        public ParticleProvider<T> create(ExtendedSpriteSet var1);
    }

    @FunctionalInterface
    public static interface BlockEntityRendererFactory<T extends BlockEntity> {
        public BlockEntityRenderer<T> create(Context var1);

        public static class Context {
            private final BlockEntityRenderDispatcher renderDispatcher;
            private final BlockRenderDispatcher renderManager;
            private final ItemRenderer itemRenderer;
            private final EntityRenderDispatcher entityRenderDispatcher;
            private final EntityModelSet layerRenderDispatcher;
            private final Font textRenderer;

            public Context(BlockEntityRenderDispatcher renderDispatcher, BlockRenderDispatcher renderManager, ItemRenderer itemRenderer, EntityRenderDispatcher entityRenderDispatcher, EntityModelSet layerRenderDispatcher, Font textRenderer) {
                this.renderDispatcher = renderDispatcher;
                this.renderManager = renderManager;
                this.itemRenderer = itemRenderer;
                this.entityRenderDispatcher = entityRenderDispatcher;
                this.layerRenderDispatcher = layerRenderDispatcher;
                this.textRenderer = textRenderer;
            }

            public BlockEntityRenderDispatcher getRenderDispatcher() {
                return this.renderDispatcher;
            }

            public BlockRenderDispatcher getRenderManager() {
                return this.renderManager;
            }

            public EntityRenderDispatcher getEntityRenderDispatcher() {
                return this.entityRenderDispatcher;
            }

            public ItemRenderer getItemRenderer() {
                return this.itemRenderer;
            }

            public EntityModelSet getLayerRenderDispatcher() {
                return this.layerRenderDispatcher;
            }

            public ModelPart getLayerModelPart(ModelLayerLocation modelLayer) {
                return this.layerRenderDispatcher.bakeLayer(modelLayer);
            }

            public Font getTextRenderer() {
                return this.textRenderer;
            }
        }
    }

    public static interface ExtendedSpriteSet
    extends SpriteSet {
        public TextureAtlas getAtlas();

        public List<TextureAtlasSprite> getSprites();
    }
}

