/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;

public class BlockUseEvent
extends BaseEvent {
    public BlockState state;
    public Level world;
    public BlockPos pos;
    public Player player;
    public InteractionHand hand;
    public BlockHitResult hit;
    public ItemStack stack;

    public BlockUseEvent(BlockState state, Level world, BlockPos pos, net.minecraft.world.entity.player.Player player, InteractionHand hand, BlockHitResult hit) {
        this.state = state;
        this.world = world;
        this.pos = pos;
        this.player = new Player(player);
        this.hand = hand;
        this.hit = hit;
        this.stack = this.player.getStackInHand(hand);
    }

    public BlockHitResult getHit() {
        return this.hit;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Player getPlayer() {
        return this.player;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isClient() {
        return this.world.isClientSide();
    }

    public CompatActionResult success() {
        return CompatActionResult.SUCCESS;
    }

    public CompatActionResult fail() {
        return CompatActionResult.FAIL;
    }

    public CompatActionResult pass() {
        return CompatActionResult.PASS;
    }

    public CompatActionResult consume() {
        return CompatActionResult.CONSUME;
    }

    public boolean hasBlockEntity() {
        return WorldUtil.hasBlockEntity(this.world, this.pos);
    }

    public BlockEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.pos);
    }

    public boolean isSneaking() {
        return this.player.isSneaking();
    }

    public World getMidohraWorld() {
        return World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraState() {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.state);
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.pos);
    }

    public BlockWrapper getBlockWrapper() {
        return BlockWrapper.of(this.state.getBlock());
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

