/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import dev.architectury.registry.CreativeTabRegistry;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.core.registry.MCPLRegistry1_20;
import net.pitan76.mcpitanlib.midohra.item.ItemGroupWrapper;

public class CreativeTabBuilder {
    private final ResourceLocation identifier;
    private Component displayName = null;
    private Supplier<ItemStack> iconSupplier = null;
    private boolean noRenderedName = false;
    private boolean noScrollbar = false;
    private boolean special = false;
    private String texture;

    @Deprecated
    public CreativeTabBuilder(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    public static CreativeTabBuilder create(ResourceLocation identifier) {
        return new CreativeTabBuilder(identifier);
    }

    public static CreativeTabBuilder create(CompatIdentifier identifier) {
        return CreativeTabBuilder.create(identifier.toMinecraft());
    }

    public CreativeTabBuilder setDisplayName(Component text) {
        this.displayName = text;
        return this;
    }

    public CreativeTabBuilder setIcon(Supplier<ItemStack> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    public CreativeTabBuilder setIcon(Item item) {
        return this.setIcon(() -> new ItemStack((ItemLike)item));
    }

    public void noRenderedName() {
        this.noRenderedName = true;
    }

    public void noScrollbar() {
        this.noScrollbar = true;
    }

    public void special() {
        this.special = true;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public CreativeModeTab build() {
        return CreativeTabRegistry.create((T builder) -> {
            if (this.displayName != null) {
                builder.title(this.displayName);
            } else {
                builder.title((Component)TextUtil.translatable("itemGroup." + this.identifier.getNamespace() + "." + this.identifier.getPath()));
            }
            if (this.iconSupplier != null) {
                builder.icon(this.iconSupplier);
            }
            if (this.noRenderedName) {
                builder.hideTitle();
            }
            if (this.noScrollbar) {
                builder.noScrollBar();
            }
            if (this.special) {
                builder.alignedRight();
            }
            if (this.texture != null) {
                builder.backgroundTexture(IdentifierUtil.id(this.texture));
            }
        });
    }

    public ItemGroupWrapper getBuiltWrapper() {
        if (MCPLRegistry1_20.REGISTRY_SUPPLIER_ITEM_GROUP_CACHE.containsKey(this.identifier)) {
            return ItemGroupWrapper.of((CreativeModeTab)MCPLRegistry1_20.REGISTRY_SUPPLIER_ITEM_GROUP_CACHE.get(this.identifier).getOrNull());
        }
        return ItemGroupWrapper.of(this.build());
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public CompatIdentifier getCompatIdentifier() {
        return CompatIdentifier.fromMinecraft(this.identifier);
    }
}

