/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item.tool;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.item.PostHitEvent;
import net.pitan76.mcpitanlib.api.event.item.PostMineEvent;
import net.pitan76.mcpitanlib.api.item.tool.CompatibleToolMaterial;
import net.pitan76.mcpitanlib.api.item.v2.CompatItemProvider;
import net.pitan76.mcpitanlib.api.item.v2.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;

public class CompatibleHoeItem
extends HoeItem
implements CompatItemProvider {
    public CompatibleItemSettings settings;

    public CompatibleHoeItem(CompatibleToolMaterial material, int attackDamage, float attackSpeed, CompatibleItemSettings settings) {
        super(material.build(), (Item.Properties)settings.build());
        this.settings = settings;
    }

    public CompatibleHoeItem(int attackDamage, float attackSpeed, Tier material, CompatibleItemSettings settings) {
        super(material, (Item.Properties)settings.build());
        this.settings = settings;
    }

    @Override
    public CompatibleItemSettings getCompatSettings() {
        return this.settings;
    }

    public boolean overrideIsSuitableFor(BlockState state) {
        return super.isCorrectToolForDrops(this.getDefaultInstance(), state);
    }

    @Deprecated
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.overrideIsSuitableFor(state);
    }

    public float overrideGetMiningSpeedMultiplier(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    @Deprecated
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.overrideGetMiningSpeedMultiplier(stack, state) * super.getDestroySpeed(stack, state);
    }

    @Deprecated
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return this.postHit(new PostHitEvent(stack, target, attacker));
    }

    @Deprecated
    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        return this.postMine(new PostMineEvent(stack, world, state, pos, miner));
    }

    public boolean postHit(PostHitEvent event) {
        return super.hurtEnemy(event.stack, event.target, event.attacker);
    }

    public boolean postMine(PostMineEvent event) {
        return super.mineBlock(event.stack, event.world, event.state, event.pos, event.miner);
    }

    public boolean isDamageableOnDefault() {
        return ItemStackUtil.getMaxDamage((Item)this) > 0;
    }
}

