/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.text;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.pitan76.mcpitanlib.api.text.VariableTextComponent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import org.jetbrains.annotations.Nullable;

public class TextComponent {
    private Component text;

    public TextComponent() {
        this((Component)TextUtil.empty());
    }

    public TextComponent(Component text) {
        this.text = text;
    }

    public TextComponent(String string) {
        this((Component)TextUtil.literal(string));
    }

    public Component getText() {
        return this.text;
    }

    public void setText(Component text) {
        this.text = text;
    }

    public MutableComponent asMutableText() {
        return (MutableComponent)this.text;
    }

    public VariableTextComponent asVariableTextComponent() {
        return new VariableTextComponent(this);
    }

    @Nullable
    public MutableComponent asMutableTextOrNull() {
        if (this.text instanceof MutableComponent) {
            return this.asMutableText();
        }
        return null;
    }

    public static TextComponent literal(String string) {
        return new TextComponent(string);
    }

    public static TextComponent of(String string) {
        return TextComponent.literal(string);
    }

    public static TextComponent translatable(String key) {
        return new TextComponent((Component)TextUtil.translatable(key));
    }

    public static TextComponent translatable(String key, Object ... args) {
        return new TextComponent((Component)TextUtil.translatable(key, args));
    }

    public String toString() {
        return this.getString();
    }

    public String getString() {
        return TextUtil.txt2str(this.getText());
    }

    public String superToString() {
        return super.toString();
    }

    public TextComponent copy() {
        return new TextComponent(this.getText());
    }

    public Style getStyle() {
        return this.text.getStyle();
    }

    public TextComponent setStyle(Style style) {
        if (this.text instanceof MutableComponent) {
            TextUtil.setStyle((MutableComponent)this.text, style);
        }
        return this;
    }

    public static TextComponent convert(String text) {
        return new TextComponent((Component)TextUtil.convert(text));
    }

    public static TextComponent convertWithTranslatable(String text) {
        return new TextComponent((Component)TextUtil.convertWithTranslatable(text));
    }
}

