/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUtil {
    public static CompatEnchantment getEnchantment(ResourceLocation identifier) {
        ResourceKey registryKey = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)identifier);
        return new CompatEnchantment((ResourceKey<Enchantment>)registryKey);
    }

    public static ResourceLocation getId(CompatEnchantment enchantment) {
        return enchantment.getId();
    }

    public static int getLevel(CompatEnchantment enchantment, ItemStack stack, @Nullable Level world) {
        return enchantment.getLevel(stack, world);
    }

    public static CompatEnchantment getEnchantment(CompatIdentifier identifier) {
        return EnchantmentUtil.getEnchantment(identifier.toMinecraft());
    }

    public static CompatIdentifier getCompatId(CompatEnchantment enchantment) {
        return CompatIdentifier.fromMinecraft(enchantment.getId());
    }

    public static List<CompatEnchantment> getEnchantments(ItemStack stack) {
        ArrayList<CompatEnchantment> enchantments = new ArrayList<CompatEnchantment>();
        EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet().forEach(enchantment -> {
            if (enchantment.unwrapKey().isPresent()) {
                enchantments.add(new CompatEnchantment((ResourceKey<Enchantment>)((ResourceKey)enchantment.unwrapKey().get())));
            }
        });
        return enchantments;
    }

    public static boolean hasEnchantment(ItemStack stack) {
        return EnchantmentHelper.hasAnyEnchantments((ItemStack)stack);
    }

    public static Map<CompatEnchantment, Integer> getEnchantment(ItemStack stack, @Nullable Level world) {
        HashMap<CompatEnchantment, Integer> enchantments = new HashMap<CompatEnchantment, Integer>();
        List<CompatEnchantment> enchantmentList = EnchantmentUtil.getEnchantments(stack);
        enchantmentList.forEach(enchantment -> enchantments.put((CompatEnchantment)enchantment, EnchantmentUtil.getLevel(enchantment, stack, world)));
        return enchantments;
    }

    public static void setEnchantment(ItemStack stack, Map<CompatEnchantment, Integer> enchantments, @Nullable Level world) {
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        enchantments.forEach((compatEnchantment, integer) -> builder.upgrade(compatEnchantment.getEntry(world), integer.intValue()));
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)builder.toImmutable());
    }

    public static void removeEnchantment(ItemStack stack) {
        stack.remove(DataComponents.ENCHANTMENTS);
    }
}

