/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.math;

import java.util.stream.Stream;
import net.pitan76.mcpitanlib.midohra.util.math.BlockPos;

public class ChunkPos {
    private final net.minecraft.world.level.ChunkPos pos;

    protected ChunkPos(net.minecraft.world.level.ChunkPos pos) {
        this.pos = pos;
    }

    public static ChunkPos of(net.minecraft.world.level.ChunkPos pos) {
        return new ChunkPos(pos);
    }

    public static ChunkPos of(int x, int z) {
        return ChunkPos.of(new net.minecraft.world.level.ChunkPos(x, z));
    }

    public static ChunkPos of(BlockPos pos) {
        return ChunkPos.of(new net.minecraft.world.level.ChunkPos(pos.toMinecraft()));
    }

    public static ChunkPos of(long pos) {
        return ChunkPos.of(new net.minecraft.world.level.ChunkPos(pos));
    }

    public static ChunkPos fromRegion(int x, int z) {
        return ChunkPos.of(net.minecraft.world.level.ChunkPos.minFromRegion((int)x, (int)z));
    }

    public static ChunkPos fromRegionCenter(int x, int z) {
        return ChunkPos.of(net.minecraft.world.level.ChunkPos.maxFromRegion((int)x, (int)z));
    }

    public net.minecraft.world.level.ChunkPos getRaw() {
        return this.pos;
    }

    public net.minecraft.world.level.ChunkPos toMinecraft() {
        return this.getRaw();
    }

    public int getX() {
        return this.getRaw().x;
    }

    public int getZ() {
        return this.getRaw().z;
    }

    public int getOffsetX(int offsetX) {
        return this.getRaw().getBlockX(offsetX);
    }

    public int getOffsetZ(int offsetZ) {
        return this.getRaw().getBlockZ(offsetZ);
    }

    public int getStartX() {
        return this.getRaw().getMinBlockX();
    }

    public int getStartZ() {
        return this.getRaw().getMinBlockZ();
    }

    public int getEndX() {
        return this.getRaw().getMaxBlockX();
    }

    public int getEndZ() {
        return this.getRaw().getMaxBlockZ();
    }

    public int getCenterX() {
        return this.getRaw().getMiddleBlockX();
    }

    public int getCenterZ() {
        return this.getRaw().getMiddleBlockZ();
    }

    public int getRegionX() {
        return this.getRaw().getRegionX();
    }

    public int getRegionZ() {
        return this.getRaw().getRegionZ();
    }

    public int getRegionRelativeX() {
        return this.getRaw().getRegionLocalX();
    }

    public int getRegionRelativeZ() {
        return this.getRaw().getRegionLocalZ();
    }

    public BlockPos getStartPos() {
        return BlockPos.of(this.getRaw().getWorldPosition());
    }

    public BlockPos getCenterAtY(int y) {
        return BlockPos.of(this.getRaw().getMiddleBlockPosition(y));
    }

    public BlockPos getBlockPos(int offsetX, int y, int offsetZ) {
        return BlockPos.of(this.getRaw().getBlockAt(offsetX, y, offsetZ));
    }

    public long toLong() {
        return this.getRaw().toLong();
    }

    public String toString() {
        return this.getRaw().toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChunkPos && this.getRaw().equals((Object)((ChunkPos)obj).getRaw());
    }

    public int hashCode() {
        return this.getRaw().hashCode();
    }

    public int getChebyshevDistance(ChunkPos pos) {
        return this.getRaw().getChessboardDistance(pos.getRaw());
    }

    public int getChebyshevDistance(int x, int z) {
        return this.getRaw().getChessboardDistance(x, z);
    }

    public int getSquaredDistance(ChunkPos pos) {
        return this.getRaw().distanceSquared(pos.getRaw());
    }

    public int getSquaredDistance(long pos) {
        return this.getRaw().distanceSquared(pos);
    }

    public static Stream<ChunkPos> stream(ChunkPos center, int radius) {
        return net.minecraft.world.level.ChunkPos.rangeClosed((net.minecraft.world.level.ChunkPos)center.getRaw(), (int)radius).map(ChunkPos::of);
    }

    public static Stream<ChunkPos> stream(ChunkPos pos1, ChunkPos pos2) {
        return net.minecraft.world.level.ChunkPos.rangeClosed((net.minecraft.world.level.ChunkPos)pos1.getRaw(), (net.minecraft.world.level.ChunkPos)pos2.getRaw()).map(ChunkPos::of);
    }
}

