/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;

public class BlockPlacedEvent
extends BaseEvent {
    public Level world;
    public BlockPos pos;
    public BlockState state;
    public LivingEntity placer;
    public ItemStack stack;

    public BlockPlacedEvent(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.placer = placer;
        this.stack = itemStack;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getWorld() {
        return this.world;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public LivingEntity getPlacer() {
        return this.placer;
    }

    public boolean isClient() {
        return this.world.isClientSide();
    }

    public BlockEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.getWorld(), this.getPos());
    }

    public World getMidohraWorld() {
        return World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraState() {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.state);
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.pos);
    }

    public BlockWrapper getBlockWrapper() {
        return BlockWrapper.of(this.state.getBlock());
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

