/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api;

import net.minecraft.resources.ResourceLocation;
import net.pitan76.mcpitanlib.api.registry.v2.CompatRegistryV2;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.IdentifierUtil;
import net.pitan76.mcpitanlib.api.util.Logger;

public abstract class CommonModInitializer {
    public final String MOD_ID = this.getId();
    public final String MOD_NAME = this.getName();
    public final CompatRegistryV2 registry = CompatRegistryV2.create(this.MOD_ID);
    public final Logger logger = new Logger(this.MOD_ID);

    public CommonModInitializer() {
        this.logger.initializeMessage();
        this.init();
        this.registry.allRegister();
    }

    public abstract void init();

    public abstract String getId();

    public String getName() {
        return this.getId();
    }

    public ResourceLocation id(String path) {
        return IdentifierUtil.id(this.MOD_ID, path);
    }

    public CompatIdentifier compatId(String path) {
        return CompatIdentifier.of(this.MOD_ID, path);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void trace(String message) {
        this.logger.trace(message);
    }
}

