/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.util.math;

import net.pitan76.mcpitanlib.midohra.util.math.Vector3d;
import net.pitan76.mcpitanlib.midohra.util.math.Vector3i;

public class Vector3f {
    public final float x;
    public final float y;
    public final float z;

    public Vector3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static Vector3f of(float x, float y, float z) {
        return new Vector3f(x, y, z);
    }

    public static Vector3f of(Vector3i vec) {
        return new Vector3f(vec.x, vec.y, vec.z);
    }

    public static Vector3f of(Vector3d vec) {
        return new Vector3f((float)vec.x, (float)vec.y, (float)vec.z);
    }

    public static Vector3f of(org.joml.Vector3f vec) {
        return new Vector3f(vec.x, vec.y, vec.z);
    }

    public Vector3i toInt() {
        return new Vector3i((int)this.x, (int)this.y, (int)this.z);
    }

    public Vector3d toDouble() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public org.joml.Vector3f toJoml() {
        return new org.joml.Vector3f(this.x, this.y, this.z);
    }

    public Vector3f add(Vector3f other) {
        return new Vector3f(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public Vector3f sub(Vector3f other) {
        return new Vector3f(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public Vector3f mul(float scalar) {
        return new Vector3f(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3f div(float scalar) {
        return new Vector3f(this.x / scalar, this.y / scalar, this.z / scalar);
    }

    public float dot(Vector3f other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3f cross(Vector3f other) {
        return new Vector3f(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3f normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return this.div(len);
    }

    public Vector3f add(float x, float y, float z) {
        return new Vector3f(this.x + x, this.y + y, this.z + z);
    }

    public Vector3f sub(float x, float y, float z) {
        return new Vector3f(this.x - x, this.y - y, this.z - z);
    }

    public Vector3f lerp(Vector3f to, float delta) {
        return this.mul(1.0f - delta).add(to.mul(delta));
    }

    public Vector3f rotateX(float angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        float cos = (float)Math.cos(angleRadians);
        float sin = (float)Math.sin(angleRadians);
        float newY = this.y * cos - this.z * sin;
        float newZ = this.y * sin + this.z * cos;
        return new Vector3f(this.x, newY, newZ);
    }

    public Vector3f rotateY(float angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        float cos = (float)Math.cos(angleRadians);
        float sin = (float)Math.sin(angleRadians);
        float newX = this.z * sin + this.x * cos;
        float newZ = this.z * cos - this.x * sin;
        return new Vector3f(newX, this.y, newZ);
    }

    public Vector3f rotateZ(float angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        float cos = (float)Math.cos(angleRadians);
        float sin = (float)Math.sin(angleRadians);
        float newX = this.x * cos - this.y * sin;
        float newY = this.x * sin + this.y * cos;
        return new Vector3f(newX, newY, this.z);
    }

    public Vector3f negate() {
        return new Vector3f(-this.x, -this.y, -this.z);
    }

    public Vector3f abs() {
        return new Vector3f(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public Vector3f distanceTo(Vector3f other) {
        return this.sub(other);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public static Vector3f zero() {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public static Vector3f distance(Vector3f a, Vector3f b) {
        return a.sub(b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Vector3f vec = (Vector3f)obj;
        return this.x == vec.x && this.y == vec.y && this.z == vec.z;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public int hashCode() {
        int h = Float.hashCode(this.x);
        h = 31 * h + Float.hashCode(this.y);
        h = 31 * h + Float.hashCode(this.z);
        return h;
    }
}

