/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.helper;

import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.pitan76.mcpitanlib.api.block.CompatibleBlockSettings;
import net.pitan76.mcpitanlib.api.block.ExtendBlock;
import net.pitan76.mcpitanlib.api.item.CompatFoodComponent;
import net.pitan76.mcpitanlib.api.item.CompatibleItemSettings;
import net.pitan76.mcpitanlib.api.item.CreativeTabBuilder;
import net.pitan76.mcpitanlib.api.item.ExtendItem;
import net.pitan76.mcpitanlib.api.registry.result.RegistryResult;
import net.pitan76.mcpitanlib.api.registry.v2.CompatRegistryV2;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;
import net.pitan76.mcpitanlib.core.datafixer.Pair;

public class SimpleRegister {
    public static Supplier<ExtendItem> createItem(CompatRegistryV2 registry, CompatIdentifier id, CompatibleItemSettings settings) {
        return registry.registerExtendItem(id, () -> new ExtendItem(settings));
    }

    public static Supplier<ExtendItem> createSimpleItem(CompatRegistryV2 registry, CompatIdentifier id) {
        return SimpleRegister.createItem(registry, id, new CompatibleItemSettings());
    }

    public static Supplier<ExtendItem> createFoodItem(CompatRegistryV2 registry, CompatIdentifier id, CompatFoodComponent component) {
        return SimpleRegister.createItem(registry, id, new CompatibleItemSettings().food(component));
    }

    public static Supplier<ExtendItem> createSimpleFoodItem(CompatRegistryV2 registry, CompatIdentifier id, int hunger, float saturation, boolean meat, boolean snack) {
        CompatFoodComponent component = new CompatFoodComponent().setHunger(hunger).setSaturation(saturation);
        if (meat) {
            component.setMeat();
        }
        if (snack) {
            component.setSnack();
        }
        return SimpleRegister.createFoodItem(registry, id, component);
    }

    public static Supplier<ExtendItem> createSimpleFoodItem(CompatRegistryV2 registry, CompatIdentifier id, int hunger, float saturation) {
        return SimpleRegister.createSimpleFoodItem(registry, id, hunger, saturation, false, false);
    }

    public static Pair<Supplier<ExtendBlock>, Supplier<class_1792>> createBlock(CompatRegistryV2 registry, CompatIdentifier id, CompatibleBlockSettings blockSettings, CompatibleItemSettings itemSettings) {
        Supplier<ExtendBlock> blockSupplier = registry.registerExtendBlock(id, () -> new ExtendBlock(blockSettings));
        RegistryResult<class_1792> itemRegistryResult = registry.registerItem(id, () -> ItemUtil.ofBlock((class_2248)blockSupplier.get(), itemSettings));
        Supplier<class_1792> itemSupplier = itemRegistryResult::getOrNull;
        return new Pair<Supplier<ExtendBlock>, Supplier<class_1792>>(blockSupplier, itemSupplier);
    }

    public static Pair<Supplier<ExtendBlock>, Supplier<class_1792>> createSimpleBlock(CompatRegistryV2 registry, CompatIdentifier id, CompatibleItemSettings itemSettings) {
        return SimpleRegister.createBlock(registry, id, new CompatibleBlockSettings(), itemSettings);
    }

    public static Pair<Supplier<ExtendBlock>, Supplier<class_1792>> createSimpleBlock(CompatRegistryV2 registry, CompatIdentifier id) {
        return SimpleRegister.createBlock(registry, id, new CompatibleBlockSettings(), new CompatibleItemSettings());
    }

    public static CreativeTabBuilder createCreativeTab(CompatRegistryV2 registry, CompatIdentifier id, Supplier<class_1799> icon) {
        CreativeTabBuilder builder = CreativeTabBuilder.create(id).setIcon(icon);
        registry.registerItemGroup(builder);
        return builder;
    }

    public static CreativeTabBuilder createCreativeTabByItem(CompatRegistryV2 registry, CompatIdentifier id, Supplier<class_1935> item) {
        return SimpleRegister.createCreativeTab(registry, id, () -> ItemStackUtil.create((class_1935)item.get()));
    }
}

