/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block;

import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public final class CompatibleMaterial {
    public static final CompatibleMaterial AIR = new Builder(MapColor.f_283808_).allowsMovement().lightPassesThrough().notSolid().replaceable().build();
    public static final CompatibleMaterial STRUCTURE_VOID = new Builder(MapColor.f_283808_).allowsMovement().lightPassesThrough().notSolid().replaceable().build();
    public static final CompatibleMaterial PORTAL = new Builder(MapColor.f_283808_).allowsMovement().lightPassesThrough().notSolid().blocksPistons().build();
    public static final CompatibleMaterial CARPET = new Builder(MapColor.f_283930_).allowsMovement().lightPassesThrough().notSolid().burnable().build();
    public static final CompatibleMaterial PLANT = new Builder(MapColor.f_283915_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().build();
    public static final CompatibleMaterial UNDERWATER_PLANT = new Builder(MapColor.f_283864_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().build();
    public static final CompatibleMaterial REPLACEABLE_PLANT = new Builder(MapColor.f_283915_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().burnable().build();
    public static final CompatibleMaterial NETHER_SHOOTS = new Builder(MapColor.f_283915_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().build();
    public static final CompatibleMaterial REPLACEABLE_UNDERWATER_PLANT = new Builder(MapColor.f_283864_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().build();
    public static final CompatibleMaterial WATER = new Builder(MapColor.f_283864_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().build();
    public static final CompatibleMaterial BUBBLE_COLUMN = new Builder(MapColor.f_283864_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().build();
    public static final CompatibleMaterial LAVA = new Builder(MapColor.f_283816_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().build();
    public static final CompatibleMaterial SNOW_LAYER = new Builder(MapColor.f_283811_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().build();
    public static final CompatibleMaterial FIRE = new Builder(MapColor.f_283808_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().build();
    public static final CompatibleMaterial DECORATION = new Builder(MapColor.f_283808_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().build();
    public static final CompatibleMaterial COBWEB = new Builder(MapColor.f_283930_).allowsMovement().lightPassesThrough().destroyedByPiston().build();
    public static final CompatibleMaterial SCULK = new Builder(MapColor.f_283927_).build();
    public static final CompatibleMaterial REDSTONE_LAMP = new Builder(MapColor.f_283808_).build();
    public static final CompatibleMaterial ORGANIC_PRODUCT = new Builder(MapColor.f_283744_).build();
    public static final CompatibleMaterial SOIL = new Builder(MapColor.f_283762_).build();
    public static final CompatibleMaterial SOLID_ORGANIC = new Builder(MapColor.f_283824_).build();
    public static final CompatibleMaterial DENSE_ICE = new Builder(MapColor.f_283828_).build();
    public static final CompatibleMaterial AGGREGATE = new Builder(MapColor.f_283761_).build();
    public static final CompatibleMaterial SPONGE = new Builder(MapColor.f_283832_).build();
    public static final CompatibleMaterial SHULKER_BOX = new Builder(MapColor.f_283889_).build();
    public static final CompatibleMaterial WOOD = new Builder(MapColor.f_283825_).burnable().build();
    public static final CompatibleMaterial NETHER_WOOD = new Builder(MapColor.f_283825_).build();
    public static final CompatibleMaterial BAMBOO_SAPLING = new Builder(MapColor.f_283825_).burnable().destroyedByPiston().allowsMovement().build();
    public static final CompatibleMaterial BAMBOO = new Builder(MapColor.f_283825_).burnable().destroyedByPiston().build();
    public static final CompatibleMaterial WOOL = new Builder(MapColor.f_283930_).burnable().build();
    public static final CompatibleMaterial TNT = new Builder(MapColor.f_283816_).burnable().lightPassesThrough().build();
    public static final CompatibleMaterial LEAVES = new Builder(MapColor.f_283915_).burnable().lightPassesThrough().destroyedByPiston().build();
    public static final CompatibleMaterial GLASS = new Builder(MapColor.f_283808_).lightPassesThrough().build();
    public static final CompatibleMaterial ICE = new Builder(MapColor.f_283828_).lightPassesThrough().build();
    public static final CompatibleMaterial CACTUS = new Builder(MapColor.f_283915_).lightPassesThrough().destroyedByPiston().build();
    public static final CompatibleMaterial STONE = new Builder(MapColor.f_283947_).build();
    public static final CompatibleMaterial METAL = new Builder(MapColor.f_283906_).build();
    public static final CompatibleMaterial SNOW_BLOCK = new Builder(MapColor.f_283811_).build();
    public static final CompatibleMaterial REPAIR_STATION = new Builder(MapColor.f_283906_).blocksPistons().build();
    public static final CompatibleMaterial BARRIER = new Builder(MapColor.f_283808_).blocksPistons().build();
    public static final CompatibleMaterial PISTON = new Builder(MapColor.f_283947_).blocksPistons().build();
    public static final CompatibleMaterial MOSS_BLOCK = new Builder(MapColor.f_283915_).destroyedByPiston().build();
    public static final CompatibleMaterial GOURD = new Builder(MapColor.f_283915_).destroyedByPiston().build();
    public static final CompatibleMaterial EGG = new Builder(MapColor.f_283915_).destroyedByPiston().build();
    public static final CompatibleMaterial CAKE = new Builder(MapColor.f_283808_).destroyedByPiston().build();
    public static final CompatibleMaterial AMETHYST = new Builder(MapColor.f_283889_).build();
    public static final CompatibleMaterial POWDER_SNOW = new Builder(MapColor.f_283811_).notSolid().allowsMovement().build();
    private final MapColor color;
    private final PushReaction pistonBehavior;
    private final boolean burnable;
    private final boolean liquid;
    private final boolean replaceable;
    private final boolean solid;

    public CompatibleMaterial(MapColor color, boolean liquid, boolean solid, boolean burnable, boolean replaceable, PushReaction pistonBehavior) {
        this.color = color;
        this.liquid = liquid;
        this.solid = solid;
        this.burnable = burnable;
        this.replaceable = replaceable;
        this.pistonBehavior = pistonBehavior;
    }

    public boolean isLiquid() {
        return this.liquid;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean isBurnable() {
        return this.burnable;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public PushReaction getPistonBehavior() {
        return this.pistonBehavior;
    }

    public MapColor getColor() {
        return this.color;
    }

    public static class Builder {
        private PushReaction pistonBehavior = PushReaction.NORMAL;
        private boolean blocksMovement = true;
        private boolean burnable;
        private boolean liquid;
        private boolean replaceable;
        private boolean solid = true;
        private final MapColor color;
        private boolean blocksLight = true;

        public Builder(MapColor color) {
            this.color = color;
        }

        public Builder liquid() {
            this.liquid = true;
            return this;
        }

        public Builder notSolid() {
            this.solid = false;
            return this;
        }

        public Builder allowsMovement() {
            this.blocksMovement = false;
            return this;
        }

        Builder lightPassesThrough() {
            this.blocksLight = false;
            return this;
        }

        protected Builder burnable() {
            this.burnable = true;
            return this;
        }

        public Builder replaceable() {
            this.replaceable = true;
            return this;
        }

        protected Builder destroyedByPiston() {
            this.pistonBehavior = PushReaction.DESTROY;
            return this;
        }

        protected Builder blocksPistons() {
            this.pistonBehavior = PushReaction.BLOCK;
            return this;
        }

        public CompatibleMaterial build() {
            return new CompatibleMaterial(this.color, this.liquid, this.solid, this.burnable, this.replaceable, this.pistonBehavior);
        }
    }
}

