/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block.args.v2;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.event.item.ItemUseOnBlockEvent;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.holder.BlockStatePropertyHolder;
import net.pitan76.mcpitanlib.midohra.util.math.Direction;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;
import net.pitan76.mcpitanlib.mixin.ItemUsageContextMixin;
import org.jetbrains.annotations.Nullable;

public class PlacementStateArgs
extends BaseEvent
implements BlockStatePropertyHolder {
    public BlockPlaceContext ctx;
    @Nullable
    public Block block;

    public PlacementStateArgs(BlockPlaceContext ctx) {
        this.ctx = ctx;
    }

    public PlacementStateArgs(BlockPlaceContext ctx, @Nullable Block block) {
        this.ctx = ctx;
        this.block = block;
    }

    public boolean canPlace() {
        return this.ctx.m_7059_();
    }

    public BlockPos getRawPos() {
        return this.ctx.m_8083_();
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getRawPos());
    }

    public Player getPlayer() {
        return new Player(this.ctx.m_43723_());
    }

    public Direction[] getPlacementDirections() {
        net.minecraft.core.Direction[] rawDirs = this.getRawPlacementDirections();
        Direction[] directions = new Direction[rawDirs.length];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = Direction.of(rawDirs[i]);
        }
        return directions;
    }

    public net.minecraft.core.Direction[] getRawPlacementDirections() {
        return this.ctx.m_6232_();
    }

    public InteractionHand getHand() {
        return this.ctx.m_43724_();
    }

    public Direction getSide() {
        return Direction.of(this.getRawSide());
    }

    public net.minecraft.core.Direction getRawSide() {
        return this.ctx.m_43719_();
    }

    public Direction getHorizontalPlayerFacing() {
        return Direction.of(this.getRawHorizontalPlayerFacing());
    }

    public net.minecraft.core.Direction getRawHorizontalPlayerFacing() {
        return this.ctx.m_8125_();
    }

    public float getPlayerYaw() {
        return this.ctx.m_7074_();
    }

    public World getWorld() {
        return World.of(this.ctx.m_43725_());
    }

    public IWorldView getWorldView() {
        return this.getWorld();
    }

    public boolean isClient() {
        return this.getWorld().isClient();
    }

    public Vec3 getHitPos() {
        return this.ctx.m_43720_();
    }

    public boolean canReplaceExisting() {
        return this.ctx.m_7058_();
    }

    @Deprecated
    public ItemUsageContextMixin getIUCAccessor() {
        return (ItemUsageContextMixin)this.ctx;
    }

    public BlockHitResult getHitResult() {
        return this.getIUCAccessor().getHit();
    }

    public ItemUseOnBlockEvent toItemUseOnBlockEvent() {
        return new ItemUseOnBlockEvent(this.getWorld().getRaw(), this.getPlayer().getPlayerEntity(), this.getHand(), this.ctx.m_43722_(), this.getHitResult());
    }

    public BlockPlaceContext getCtx() {
        return this.ctx;
    }

    @Nullable
    public Block getRawBlock() {
        return this.block;
    }

    public boolean isBlockExist() {
        return this.block != null;
    }

    public BlockState getRawBlockState() {
        return BlockStateUtil.getDefaultState(this.block);
    }

    public BlockEntity getRawBlockEntity() {
        return this.getWorld().getBlockEntity(this.getRawPos());
    }

    public BlockWrapper getBlock() {
        return BlockWrapper.of(this.block);
    }

    public <T extends Comparable<T>, V extends T> BlockState with(Property<T> property, V value) {
        if (this.block == null) {
            return null;
        }
        return BlockStateUtil.with(BlockStateUtil.getDefaultState(this.block), property, value);
    }

    @Override
    public net.pitan76.mcpitanlib.midohra.block.BlockState getBlockState() {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.getRawBlockState());
    }

    public BlockEntityWrapper getBlockEntity() {
        return this.getWorld().getBlockEntity(this.getPos());
    }
}

