/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.entity;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffect;
import net.pitan76.mcpitanlib.api.entity.effect.CompatStatusEffectInstance;
import net.pitan76.mcpitanlib.api.gui.ExtendedNamedScreenHandlerFactory;
import net.pitan76.mcpitanlib.api.item.CompatFoodComponent;
import net.pitan76.mcpitanlib.api.sound.CompatSoundCategory;
import net.pitan76.mcpitanlib.api.sound.CompatSoundEvent;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.ScreenHandlerUtil;
import net.pitan76.mcpitanlib.core.player.ItemCooldown;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;
import net.pitan76.mcpitanlib.midohra.world.World;

public class Player {
    private final net.minecraft.world.entity.player.Player entity;
    public ItemCooldown itemCooldown = new ItemCooldown(this);

    public net.minecraft.world.entity.player.Player getEntity() {
        return this.entity;
    }

    public net.minecraft.world.entity.player.Player getPlayerEntity() {
        return this.getEntity();
    }

    public Player(net.minecraft.world.entity.player.Player playerEntity) {
        this.entity = playerEntity;
    }

    public Inventory getInv() {
        return this.getEntity().m_150109_();
    }

    public Inventory getInventory() {
        return this.getInv();
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getArmor() {
        return this.getInv().f_35975_;
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getMain() {
        return this.getInv().f_35974_;
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getOffHand() {
        return this.getInv().f_35976_;
    }

    public int getSelectSlot() {
        return this.getInv().f_35977_;
    }

    public int getInvSize() {
        return this.getInv().m_6643_();
    }

    public OptionalInt openGuiScreen(MenuProvider factory) {
        return this.getEntity().m_5893_(factory);
    }

    public OptionalInt openGuiScreen(Level world, BlockState state, BlockPos pos) {
        return this.openGuiScreen(state.m_60750_(world, pos));
    }

    public boolean isServerPlayerEntity() {
        return this.getEntity() instanceof ServerPlayer;
    }

    public void openExtendedMenu(MenuProvider provider, Consumer<FriendlyByteBuf> bufWriter) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openExtendedMenu((ServerPlayer)this.getPlayerEntity(), provider, bufWriter);
        }
    }

    public void openExtendedMenu(ExtendedMenuProvider provider) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openExtendedMenu((ServerPlayer)this.getPlayerEntity(), provider);
        }
    }

    public void openExtendedMenu(ExtendedNamedScreenHandlerFactory provider) {
        this.openExtendedMenu((ExtendedMenuProvider)provider);
    }

    public void openMenu(MenuProvider provider) {
        if (this.isServerPlayerEntity()) {
            ScreenHandlerUtil.openMenu((ServerPlayer)this.getPlayerEntity(), provider);
        }
    }

    public void insertStack(net.minecraft.world.item.ItemStack stack) {
        this.getInv().m_36054_(stack);
    }

    public void insertStack(int slot, net.minecraft.world.item.ItemStack stack) {
        this.getInv().m_36040_(slot, stack);
    }

    public void offerOrDrop(net.minecraft.world.item.ItemStack itemStack) {
        this.getInv().m_150079_(itemStack);
    }

    public void giveStack(net.minecraft.world.item.ItemStack stack) {
        this.getEntity().m_36356_(stack);
    }

    public String getName() {
        return this.getEntity().m_7755_().getString();
    }

    public UUID getUUID() {
        return this.getEntity().m_20148_();
    }

    public Abilities getAbilities() {
        return this.getEntity().m_150110_();
    }

    public boolean isCreative() {
        return this.getAbilities().f_35937_;
    }

    public boolean isFlying() {
        return this.getAbilities().f_35935_;
    }

    public boolean isInvulnerable() {
        return this.getAbilities().f_35934_;
    }

    public Level getWorld() {
        return this.getEntity().m_9236_();
    }

    public AbstractContainerMenu getCurrentScreenHandler() {
        return this.getEntity().f_36096_;
    }

    public boolean isSneaking() {
        return this.getEntity().m_6144_();
    }

    public net.minecraft.world.item.ItemStack getCursorStack() {
        return this.getCurrentScreenHandler().m_142621_();
    }

    public boolean isClient() {
        return this.getWorld().m_5776_();
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public void readCustomDataFromNbt(CompoundTag nbt) {
        this.getEntity().m_7378_(nbt);
    }

    public void writeCustomDataToNbt(CompoundTag nbt) {
        this.getEntity().m_7380_(nbt);
    }

    public void sendMessage(Component text) {
        this.getEntity().m_5661_(text, false);
    }

    public void sendActionBar(Component text) {
        this.getEntity().m_5661_(text, true);
    }

    public void equipStack(EquipmentSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.getEntity().m_8061_(slot, stack);
    }

    public void dropStack(net.minecraft.world.item.ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        this.getEntity().m_7197_(stack, throwRandomly, retainOwnership);
    }

    public void dropStack(net.minecraft.world.item.ItemStack stack, boolean retainOwnership) {
        this.dropStack(stack, false, retainOwnership);
    }

    public void dropStack(net.minecraft.world.item.ItemStack stack) {
        this.dropStack(stack, false, false);
    }

    public BlockPos getBlockPos() {
        return this.getEntity().m_20183_();
    }

    public Vec3 getPos() {
        return this.getEntity().m_20182_();
    }

    public net.minecraft.world.item.ItemStack getStackInHand(InteractionHand hand) {
        return this.getEntity().m_21120_(hand);
    }

    public void heal(float amount) {
        this.getEntity().m_5634_(amount);
    }

    public float getYaw() {
        return this.getEntity().m_146908_();
    }

    public float getPitch() {
        return this.getEntity().m_146909_();
    }

    public void playSound(SoundEvent event, SoundSource category, float volume, float pitch) {
        Optional<ServerPlayer> player;
        if (this.isServerPlayerEntity() && (player = this.getServerPlayer()).isPresent()) {
            player.get().m_6330_(event, category, volume, pitch);
            return;
        }
        this.playSound(event, volume, pitch);
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        Optional<ServerPlayer> player;
        if (this.isServerPlayerEntity() && (player = this.getServerPlayer()).isPresent()) {
            player.get().m_5496_(event, volume, pitch);
            return;
        }
        this.getEntity().m_5496_(event, volume, pitch);
    }

    public void playSound(CompatSoundEvent event, CompatSoundCategory category, float volume, float pitch) {
        this.playSound(event.get(), category.get(), volume, pitch);
    }

    public void playSound(CompatSoundEvent event, float volume, float pitch) {
        this.playSound(event.get(), volume, pitch);
    }

    public ItemCooldown getItemCooldown() {
        return this.itemCooldown;
    }

    public ItemCooldowns getItemCooldownManager() {
        return this.getEntity().m_36335_();
    }

    public void incrementStat(Stat<?> stat) {
        this.getEntity().m_36246_(stat);
    }

    public <T> void incrementStat(StatType<T> type, T object) {
        this.getEntity().m_36246_(type.m_12902_(object));
    }

    public void incrementStat(ResourceLocation id) {
        this.getEntity().m_36220_(id);
    }

    public void incrementStat(CompatIdentifier id) {
        this.getEntity().m_36220_(id.toMinecraft());
    }

    public void teleport(double x, double y, double z) {
        this.getEntity().m_20984_(x, y, z, false);
    }

    public net.minecraft.world.item.ItemStack getMainHandStack() {
        return this.getStackInHand(InteractionHand.MAIN_HAND);
    }

    public net.minecraft.world.item.ItemStack getOffHandStack() {
        return this.getStackInHand(InteractionHand.OFF_HAND);
    }

    public Direction getHorizontalFacing() {
        return this.getEntity().m_6350_();
    }

    public double getX() {
        return this.getEntity().m_20185_();
    }

    public double getY() {
        return this.getEntity().m_20186_();
    }

    public double getZ() {
        return this.getEntity().m_20189_();
    }

    public boolean isServerPlayer() {
        return this.getEntity() instanceof ServerPlayer;
    }

    public Optional<ServerPlayer> getServerPlayer() {
        if (this.isServerPlayer()) {
            return Optional.of((ServerPlayer)this.getEntity());
        }
        return Optional.empty();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Optional<LocalPlayer> getClientPlayer() {
        if (this.getEntity() instanceof LocalPlayer) {
            return Optional.of((LocalPlayer)this.getEntity());
        }
        return Optional.empty();
    }

    public void setVelocity(double x, double y, double z) {
        this.getEntity().m_20334_(x, y, z);
    }

    public void setVelocity(Vec3 velocity) {
        this.getEntity().m_20256_(velocity);
    }

    public Vec3 getVelocity() {
        return this.getEntity().m_20184_();
    }

    public Optional<ServerGamePacketListenerImpl> getNetworkHandler() {
        Optional<ServerPlayer> player = this.getServerPlayer();
        return player.map(sp -> sp.f_8906_);
    }

    public boolean hasNetworkHandler() {
        return this.getNetworkHandler().isPresent();
    }

    public boolean isSpectator() {
        return this.getEntity().m_5833_();
    }

    public Optional<net.minecraft.world.item.ItemStack> getCurrentHandItem() {
        boolean playerIsHoldingInOffHand;
        boolean playerIsHoldingInMainHand;
        boolean bl = playerIsHoldingInMainHand = !this.getMainHandStack().m_41619_();
        if (playerIsHoldingInMainHand) {
            return Optional.ofNullable(this.getMainHandStack());
        }
        boolean bl2 = playerIsHoldingInOffHand = !this.getOffHandStack().m_41619_();
        if (playerIsHoldingInOffHand) {
            return Optional.ofNullable(this.getOffHandStack());
        }
        return Optional.empty();
    }

    public void addStatusEffect(CompatStatusEffectInstance effect) {
        this.getEntity().m_7292_(effect.getInstance());
    }

    public void removeStatusEffect(CompatStatusEffect effect) {
        this.getEntity().m_21195_(effect.getStatusEffect(this.getWorld()));
    }

    public List<CompatStatusEffectInstance> getStatusEffects() {
        ArrayList<CompatStatusEffectInstance> compatEffects = new ArrayList<CompatStatusEffectInstance>();
        for (MobEffectInstance effect : this.getEntity().m_21220_()) {
            compatEffects.add(new CompatStatusEffectInstance(effect));
        }
        return compatEffects;
    }

    public void addExperience(int experience) {
        this.getEntity().m_6756_(experience);
    }

    public int getExperienceLevel() {
        return this.getEntity().f_36078_;
    }

    public void addExperienceLevels(int levels) {
        this.getEntity().m_6749_(levels);
    }

    public void setExperienceLevel(int level) {
        this.getEntity().f_36078_ = level;
    }

    public void addScore(int score) {
        this.getEntity().m_36401_(score);
    }

    public int getScore() {
        return this.getEntity().m_36344_();
    }

    public void setScore(int score) {
        this.getEntity().m_36397_(score);
    }

    public int getTotalExperience() {
        return this.getEntity().f_36079_;
    }

    public void setTotalExperience(int experience) {
        this.getEntity().f_36079_ = experience;
    }

    public boolean isSwimming() {
        return this.getEntity().m_6069_();
    }

    public void setStackInHand(InteractionHand hand, net.minecraft.world.item.ItemStack stack) {
        this.getEntity().m_21008_(hand, stack);
    }

    public void setStackInHand(InteractionHand hand, ItemStack stack) {
        this.setStackInHand(hand, stack.toMinecraft());
    }

    public ItemStack getMidohraStackInHand(InteractionHand hand) {
        return ItemStack.of(this.getStackInHand(hand));
    }

    public InteractionHand getActiveHand() {
        return this.getEntity().m_7655_();
    }

    public float getBlockBreakingSpeed(BlockState state) {
        return this.getEntity().m_36281_(state);
    }

    public boolean canHarvest(BlockState state) {
        return this.getEntity().m_36298_(state);
    }

    public World getMidohraWorld() {
        return World.of(this.getWorld());
    }

    public void eatFood(net.minecraft.world.item.ItemStack stack, CompatFoodComponent foodComponent) {
        this.getEntity().m_5584_(this.getWorld(), stack);
    }
}

