/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.api.util.entity.EquipmentSlotUtil;
import net.pitan76.mcpitanlib.api.util.entity.LivingEntityUtil;

public class InventoryTickEvent
extends BaseEvent {
    public ItemStack stack;
    public Level world;
    public Entity entity;
    public int slot;
    public boolean selected;
    public EquipmentSlot equipmentSlot;

    public InventoryTickEvent(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        this.stack = stack;
        this.world = world;
        this.entity = entity;
        this.slot = slot;
        this.selected = selected;
        this.equipmentSlot = EquipmentSlotUtil.fromEntitySlotId(slot);
    }

    public InventoryTickEvent(ItemStack stack, ServerLevel world, Entity entity, EquipmentSlot slot) {
        this(stack, (Level)world, entity, EquipmentSlotUtil.getEntitySlotId(slot), InventoryTickEvent.isSelected(entity, slot, stack));
        this.equipmentSlot = slot;
    }

    private static boolean isSelected(Entity entity, EquipmentSlot slot, ItemStack stack) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack equippedStack = LivingEntityUtil.getEquippedStack(livingEntity, slot);
            return equippedStack.m_150930_(stack.m_41720_()) && equippedStack.m_41613_() == stack.m_41613_();
        }
        return false;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public Level getWorld() {
        return this.world;
    }

    public boolean isServer() {
        return !this.isClient();
    }

    public ServerLevel getServerWorld() {
        return (ServerLevel)this.world;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isClient() {
        return WorldUtil.isClient(this.world);
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }
}

