/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.offlineplayer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.pitan76.easyapi.FileControl;
import net.pitan76.easyapi.config.JsonConfig;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.offlineplayer.OfflinePlayer;
import net.pitan76.mcpitanlib.api.util.PlatformUtil;
import net.pitan76.mcpitanlib.midohra.server.PlayerManager;

public class OfflinePlayerManager {
    public static OfflinePlayerManager INSTANCE = new OfflinePlayerManager();
    public static final File DEFAULT_FILE = new File(PlatformUtil.getConfigFolderAsFile(), "mcpitanlib/offlineplayer.json");
    private final List<OfflinePlayer> offlinePlayers = new ArrayList<OfflinePlayer>();

    protected OfflinePlayerManager() {
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.load();
    }

    public File getFile() {
        return DEFAULT_FILE;
    }

    public void load() {
        if (FileControl.fileExists(this.getFile())) {
            JsonConfig config = new JsonConfig(this.getFile());
            config.configMap.forEach((key, value) -> this.offlinePlayers.add(new OfflinePlayer((String)key, (String)value)));
        }
    }

    public void save() {
        if (!FileControl.fileExists(this.getFile().getParentFile())) {
            this.getFile().getParentFile().mkdirs();
        }
        JsonConfig config = new JsonConfig();
        this.offlinePlayers.forEach(offlinePlayer -> config.set(offlinePlayer.uuid, offlinePlayer.name));
        config.save(this.getFile(), true);
    }

    public OfflinePlayer getPlayer(String uuid) {
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.uuid.equals(uuid)) continue;
            return offlinePlayer;
        }
        return null;
    }

    public OfflinePlayer getPlayerByName(String name) {
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.name.equals(name)) continue;
            return offlinePlayer;
        }
        return null;
    }

    public void addPlayer(OfflinePlayer offlinePlayer) {
        this.offlinePlayers.add(offlinePlayer);
    }

    public void removePlayer(OfflinePlayer offlinePlayer) {
        this.offlinePlayers.remove(offlinePlayer);
    }

    public void addPlayer(String uuid, String name) {
        if (this.containsPlayerByUUID(uuid)) {
            return;
        }
        this.addPlayer(new OfflinePlayer(uuid, name));
    }

    public void removePlayer(String uuid) {
        this.removePlayer(this.getPlayer(uuid));
    }

    public boolean containsPlayerByUUID(String uuid) {
        return this.getPlayer(uuid) != null;
    }

    public boolean containsPlayerByName(String name) {
        return this.getPlayerByName(name) != null;
    }

    public boolean containsPlayer(OfflinePlayer offlinePlayer) {
        return this.offlinePlayers.contains(offlinePlayer);
    }

    public boolean containsPlayer(UUID uuid) {
        return this.containsPlayerByUUID(uuid.toString());
    }

    public static Optional<Player> getOnlinePlayer(UUID uuid, PlayerManager playerManager) {
        if (playerManager.hasPlayerByUUID(uuid)) {
            return Optional.of(playerManager.getPlayerByUUID(uuid));
        }
        return Optional.empty();
    }

    public static Optional<Player> getOnlinePlayerByName(String name, PlayerManager playerManager) {
        if (playerManager.hasPlayerByName(name)) {
            return Optional.of(playerManager.getPlayerByName(name));
        }
        return Optional.empty();
    }

    public static Optional<Player> getOnlinePlayerByUUID(String uuid, PlayerManager playerManager) {
        return OfflinePlayerManager.getOnlinePlayer(UUID.fromString(uuid), playerManager);
    }

    public static Optional<Player> getOnlinePlayer(OfflinePlayer offlinePlayer, PlayerManager playerManager) {
        return OfflinePlayerManager.getOnlinePlayer(UUID.fromString(offlinePlayer.uuid), playerManager);
    }

    public UUID getUUID(String name) {
        return UUID.fromString(this.getUUIDasString(name));
    }

    public String getName(UUID uuid) {
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.uuid.equals(uuid.toString())) continue;
            return offlinePlayer.name;
        }
        return null;
    }

    public String getUUIDasString(String name) {
        for (OfflinePlayer offlinePlayer : this.offlinePlayers) {
            if (!offlinePlayer.name.equals(name)) continue;
            return offlinePlayer.uuid;
        }
        return null;
    }

    public List<OfflinePlayer> getOfflinePlayers() {
        return this.offlinePlayers;
    }

    public void clear() {
        this.offlinePlayers.clear();
    }

    public void reload() {
        this.clear();
        this.load();
    }

    public void saveAndReload() {
        this.save();
        this.reload();
    }

    public void saveAndReloadAsync() {
        new Thread(() -> {
            this.save();
            this.reload();
        }).start();
    }

    public void saveAsync() {
        new Thread(this::save).start();
    }

    public void reloadAsync() {
        new Thread(this::reload).start();
    }

    public void clearAsync() {
        new Thread(this::clear).start();
    }

    public void saveAndReloadAsync(Runnable runnable) {
        new Thread(() -> {
            this.save();
            this.reload();
            runnable.run();
        }).start();
    }

    public void saveAsync(Runnable runnable) {
        new Thread(() -> {
            this.save();
            runnable.run();
        }).start();
    }

    public void reloadAsync(Runnable runnable) {
        new Thread(() -> {
            this.reload();
            runnable.run();
        }).start();
    }

    public void clearAsync(Runnable runnable) {
        new Thread(() -> {
            this.clear();
            runnable.run();
        }).start();
    }

    public void saveAndReload(Runnable runnable) {
        this.save();
        this.reload();
        runnable.run();
    }

    public void save(Runnable runnable) {
        this.save();
        runnable.run();
    }

    public void reload(Runnable runnable) {
        this.reload();
        runnable.run();
    }

    public void clear(Runnable runnable) {
        this.clear();
        runnable.run();
    }
}

