/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.NbtUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import org.jetbrains.annotations.Nullable;

public class BlockEntityUtil {
    public static BlockEntity getBlockEntity(Level world, BlockPos pos) {
        return WorldUtil.getBlockEntity(world, pos);
    }

    public static CompoundTag getBlockEntityNbt(@Nullable Level world, BlockEntity blockEntity) {
        if (world == null) {
            world = BlockEntityUtil.getWorld(blockEntity);
        }
        if (world == null) {
            return NbtUtil.create();
        }
        return blockEntity.m_187482_();
    }

    public static CompoundTag getBlockEntityNbt(BlockEntity blockEntity) {
        return BlockEntityUtil.getBlockEntityNbt(null, blockEntity);
    }

    public static Level getWorld(BlockEntity blockEntity) {
        return blockEntity.m_58904_();
    }

    public static boolean hasWorld(BlockEntity blockEntity) {
        return blockEntity.m_58898_();
    }

    public static BlockPos getPos(BlockEntity blockEntity) {
        return blockEntity.m_58899_();
    }

    public static BlockState getCachedState(BlockEntity blockEntity) {
        return blockEntity.m_58900_();
    }

    public static BlockState getBlockState(BlockEntity blockEntity) {
        return BlockEntityUtil.getWorld(blockEntity).m_8055_(BlockEntityUtil.getPos(blockEntity));
    }

    public static Block getBlock(BlockEntity blockEntity) {
        return BlockEntityUtil.getBlockState(blockEntity).m_60734_();
    }

    public static void markRemoved(BlockEntity blockEntity) {
        blockEntity.m_7651_();
    }

    public static void markDirty(BlockEntity blockEntity) {
        blockEntity.m_6596_();
    }

    public static BlockEntityType<?> getType(BlockEntity blockEntity) {
        return blockEntity.m_58903_();
    }

    public static void readNbt(BlockEntity blockEntity, CompoundTag nbt, CompatRegistryLookup registryLookup) {
        blockEntity.m_142466_(nbt);
    }

    public static void writeNbt(BlockEntity blockEntity, CompoundTag nbt, CompatRegistryLookup registryLookup) {
        blockEntity.m_183515_(nbt);
    }

    public static void read(BlockEntity blockEntity, CompoundTag nbt, CompatRegistryLookup registryLookup) {
        blockEntity.m_142466_(nbt);
    }

    public static CompoundTag createNbt(BlockEntity blockEntity, CompatRegistryLookup registryLookup) {
        return blockEntity.m_187482_();
    }

    public static void setStackNbt(BlockEntity blockEntity, ItemStack stack, CompatRegistryLookup registryLookup) {
        blockEntity.m_187476_(stack);
    }

    public static ServerLevel getServerWorld(BlockEntity blockEntity) {
        return (ServerLevel)BlockEntityUtil.getWorld(blockEntity);
    }
}

