/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class CustomDataUtil {
    public static CompoundTag getOrCreateNbt(ItemStack stack) {
        if (!CustomDataUtil.hasNbt(stack)) {
            return NbtUtil.create();
        }
        return CustomDataUtil.getNbt(stack);
    }

    public static void setNbt(ItemStack stack, CompoundTag nbt) {
        CompoundTag components = NbtUtil.create();
        if (CustomDataUtil.hasNbt(stack)) {
            components = stack.m_41783_().m_128469_("components");
        }
        components.m_128365_("minecraft:custom_data", (Tag)nbt);
        stack.m_41784_().m_128365_("components", (Tag)components);
    }

    public static boolean hasNbt(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return false;
        }
        return stack.m_41783_().m_128441_("components") && stack.m_41783_().m_128469_("components").m_128441_("minecraft:custom_data");
    }

    public static CompoundTag getNbt(ItemStack stack) {
        CompoundTag components;
        CompoundTag customData = NbtUtil.create();
        if (!CustomDataUtil.hasNbt(stack)) {
            return customData;
        }
        if (stack.m_41783_().m_128441_("components") && (components = stack.m_41783_().m_128469_("components")).m_128441_("minecraft:custom_data")) {
            customData = components.m_128469_("minecraft:custom_data").m_6426_();
        }
        return customData;
    }

    public static void put(ItemStack stack, String key, CompoundTag value) {
        CompoundTag nbt = CustomDataUtil.getOrCreateNbt(stack);
        NbtUtil.put(nbt, key, value);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static CompoundTag get(ItemStack stack, String key) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return nbt.m_128469_(key);
    }

    public static void remove(ItemStack stack, String key) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        nbt.m_128473_(key);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static boolean has(ItemStack stack, String key) {
        if (!CustomDataUtil.hasNbt(stack)) {
            return false;
        }
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return nbt.m_128441_(key);
    }

    public static <T> T get(ItemStack stack, String key, Class<T> clazz) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return NbtUtil.get(nbt, key, clazz);
    }

    public static <T> void set(ItemStack stack, String key, T value) {
        CompoundTag nbt = CustomDataUtil.getOrCreateNbt(stack);
        NbtUtil.set(nbt, key, value);
        CustomDataUtil.setNbt(stack, nbt);
    }

    public static Set<String> getKeys(ItemStack stack) {
        CompoundTag nbt = CustomDataUtil.getNbt(stack);
        return NbtUtil.getKeys(nbt);
    }

    public static <T> void put(ItemStack stack, String key, T value) {
        CustomDataUtil.set(stack, key, value);
    }

    public static boolean contains(ItemStack stack, String key) {
        return CustomDataUtil.has(stack, key);
    }

    public static void fix_oldNbt(ItemStack stack, String[] keys) {
    }

    public static void remove(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("components")) {
            CompoundTag components = nbt.m_128469_("components");
            components.m_128473_("minecraft:custom_data");
            nbt.m_128365_("components", (Tag)components);
        }
    }
}

