/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.enchantment.CompatEnchantment;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import org.jetbrains.annotations.Nullable;

public class EnchantmentUtil {
    public static CompatEnchantment getEnchantment(ResourceLocation identifier) {
        return new CompatEnchantment((Enchantment)BuiltInRegistries.f_256876_.m_7745_(identifier));
    }

    public static ResourceLocation getId(CompatEnchantment enchantment) {
        return enchantment.getId();
    }

    public static int getLevel(CompatEnchantment enchantment, ItemStack stack, @Nullable Level world) {
        return enchantment.getLevel(stack, world);
    }

    public static CompatEnchantment getEnchantment(CompatIdentifier identifier) {
        return EnchantmentUtil.getEnchantment(identifier.toMinecraft());
    }

    public static CompatIdentifier getCompatId(CompatEnchantment enchantment) {
        return CompatIdentifier.fromMinecraft(enchantment.getId());
    }

    public static List<CompatEnchantment> getEnchantments(ItemStack stack) {
        ArrayList<CompatEnchantment> enchantments = new ArrayList<CompatEnchantment>();
        EnchantmentHelper.m_44831_((ItemStack)stack).forEach((key, value) -> enchantments.add(new CompatEnchantment((Enchantment)key)));
        return enchantments;
    }

    public static boolean hasEnchantment(ItemStack stack) {
        return stack.m_41793_();
    }

    public static Map<CompatEnchantment, Integer> getEnchantment(ItemStack stack, @Nullable Level world) {
        HashMap<CompatEnchantment, Integer> enchantments = new HashMap<CompatEnchantment, Integer>();
        List<CompatEnchantment> enchantmentList = EnchantmentUtil.getEnchantments(stack);
        enchantmentList.forEach(enchantment -> enchantments.put((CompatEnchantment)enchantment, EnchantmentUtil.getLevel(enchantment, stack, world)));
        return enchantments;
    }

    public static void setEnchantment(ItemStack stack, Map<CompatEnchantment, Integer> enchantments, @Nullable Level world) {
        HashMap enchantmentMap = new HashMap();
        enchantments.forEach((key, value) -> enchantmentMap.put(key.getEnchantment(world), value));
        EnchantmentHelper.m_44865_(enchantmentMap, (ItemStack)stack);
    }

    public static void removeEnchantment(ItemStack stack) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt.m_128441_("enchantments")) {
            stack.m_41749_("enchantments");
        }
        if (nbt.m_128441_("stored_enchantments")) {
            stack.m_41749_("stored_enchantments");
        }
        if (nbt.m_128441_("Enchantments")) {
            stack.m_41749_("Enchantments");
        }
        if (nbt.m_128441_("StoredEnchantments")) {
            stack.m_41749_("StoredEnchantments");
        }
    }
}

