/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;
import net.pitan76.mcpitanlib.api.util.CustomDataUtil;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.ItemUtil;
import net.pitan76.mcpitanlib.api.util.math.PosUtil;
import net.pitan76.mcpitanlib.api.util.math.Vec3dUtil;
import net.pitan76.mcpitanlib.api.util.math.Vec3iUtil;

public class NbtUtil {
    public static CompoundTag create() {
        return new CompoundTag();
    }

    public static void put(CompoundTag nbt, String key, CompoundTag value) {
        nbt.m_128365_(key, (Tag)value);
    }

    public static void put(CompoundTag nbt, String key, Tag value) {
        nbt.m_128365_(key, value);
    }

    public static CompoundTag get(CompoundTag nbt, String key) {
        return nbt.m_128469_(key);
    }

    public static void remove(CompoundTag nbt, String key) {
        nbt.m_128473_(key);
    }

    public static boolean has(CompoundTag nbt, String key) {
        return nbt.m_128441_(key);
    }

    public static <T> T get(CompoundTag nbt, String key, Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(nbt.m_128451_(key));
        }
        if (clazz == String.class) {
            return (T)nbt.m_128461_(key);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(nbt.m_128471_(key));
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(nbt.m_128457_(key));
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(nbt.m_128459_(key));
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(nbt.m_128454_(key));
        }
        if (clazz == CompoundTag.class) {
            return (T)nbt.m_128469_(key);
        }
        if (clazz == ListTag.class) {
            return (T)nbt.m_128423_(key);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf(nbt.m_128445_(key));
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf(nbt.m_128448_(key));
        }
        if (clazz == UUID.class) {
            return (T)nbt.m_128342_(key);
        }
        return null;
    }

    public static <T> void set(CompoundTag nbt, String key, T value) {
        if (value instanceof Integer) {
            nbt.m_128405_(key, ((Integer)value).intValue());
            return;
        }
        if (value instanceof String) {
            nbt.m_128359_(key, (String)value);
            return;
        }
        if (value instanceof Boolean) {
            nbt.m_128379_(key, ((Boolean)value).booleanValue());
            return;
        }
        if (value instanceof Float) {
            nbt.m_128350_(key, ((Float)value).floatValue());
            return;
        }
        if (value instanceof Double) {
            nbt.m_128347_(key, ((Double)value).doubleValue());
            return;
        }
        if (value instanceof Long) {
            nbt.m_128356_(key, ((Long)value).longValue());
            return;
        }
        if (value instanceof CompoundTag) {
            nbt.m_128365_(key, (Tag)((CompoundTag)value));
            return;
        }
        if (value instanceof ListTag) {
            nbt.m_128365_(key, (Tag)((ListTag)value));
            return;
        }
        if (value instanceof Byte) {
            nbt.m_128344_(key, ((Byte)value).byteValue());
            return;
        }
        if (value instanceof Short) {
            nbt.m_128376_(key, ((Short)value).shortValue());
            return;
        }
        if (value instanceof UUID) {
            nbt.m_128362_(key, (UUID)value);
            return;
        }
    }

    public static Set<String> getKeys(CompoundTag nbt) {
        return nbt.m_128431_();
    }

    public static ListTag getList(CompoundTag nbt, String key) {
        return (ListTag)nbt.m_128423_(key);
    }

    public static ListTag getList(CompoundTag nbt, String key, int type) {
        return nbt.m_128437_(key, type);
    }

    public static ListTag getNbtCompoundList(CompoundTag nbt, String key) {
        return nbt.m_128437_(key, 10);
    }

    public static CompoundTag copy(CompoundTag nbt) {
        return nbt.m_6426_();
    }

    public static void putInt(CompoundTag nbt, String key, int value) {
        NbtUtil.set(nbt, key, value);
    }

    public static int getInt(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Integer.class);
        }
        return 0;
    }

    public static void putString(CompoundTag nbt, String key, String value) {
        NbtUtil.set(nbt, key, value);
    }

    public static String getString(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, String.class);
        }
        return "";
    }

    public static void putBoolean(CompoundTag nbt, String key, boolean value) {
        NbtUtil.set(nbt, key, value);
    }

    public static boolean getBoolean(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Boolean.class);
        }
        return false;
    }

    public static void putFloat(CompoundTag nbt, String key, float value) {
        NbtUtil.set(nbt, key, Float.valueOf(value));
    }

    public static float getFloat(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Float.class).floatValue();
        }
        return 0.0f;
    }

    public static void putDouble(CompoundTag nbt, String key, double value) {
        NbtUtil.set(nbt, key, value);
    }

    public static double getDouble(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Double.class);
        }
        return 0.0;
    }

    public static void putLong(CompoundTag nbt, String key, long value) {
        NbtUtil.set(nbt, key, value);
    }

    public static long getLong(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Long.class);
        }
        return 0L;
    }

    public static void putByte(CompoundTag nbt, String key, byte value) {
        NbtUtil.set(nbt, key, value);
    }

    public static byte getByte(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Byte.class);
        }
        return 0;
    }

    public static void putShort(CompoundTag nbt, String key, short value) {
        NbtUtil.set(nbt, key, value);
    }

    public static short getShort(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, Short.class);
        }
        return 0;
    }

    public static void putUuid(CompoundTag nbt, String key, UUID value) {
        NbtUtil.set(nbt, key, value);
    }

    public static UUID getUuid(CompoundTag nbt, String key) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.get(nbt, key, UUID.class);
        }
        return null;
    }

    public static void setBlockPos(CompoundTag nbt, String key, BlockPos pos) {
        CompoundTag posNbt = NbtUtil.create();
        NbtUtil.putInt(posNbt, "x", pos.m_123341_());
        NbtUtil.putInt(posNbt, "y", pos.m_123342_());
        NbtUtil.putInt(posNbt, "z", pos.m_123343_());
        NbtUtil.put(nbt, key, posNbt);
    }

    public static BlockPos getBlockPos(CompoundTag nbt, String key) {
        CompoundTag posNbt = NbtUtil.get(nbt, key);
        return PosUtil.flooredBlockPos(NbtUtil.getInt(posNbt, "x"), NbtUtil.getInt(posNbt, "y"), NbtUtil.getInt(posNbt, "z"));
    }

    public static void putVec3i(CompoundTag nbt, String key, Vec3i vec3i) {
        CompoundTag vec3iNbt = NbtUtil.create();
        NbtUtil.putInt(vec3iNbt, "x", vec3i.m_123341_());
        NbtUtil.putInt(vec3iNbt, "y", vec3i.m_123342_());
        NbtUtil.putInt(vec3iNbt, "z", vec3i.m_123343_());
        NbtUtil.put(nbt, key, vec3iNbt);
    }

    public static Vec3i getVec3i(CompoundTag nbt, String key) {
        CompoundTag vec3iNbt = NbtUtil.get(nbt, key);
        return Vec3iUtil.create(NbtUtil.getInt(vec3iNbt, "x"), NbtUtil.getInt(vec3iNbt, "y"), NbtUtil.getInt(vec3iNbt, "z"));
    }

    public static void putVec3d(CompoundTag nbt, String key, Vec3 vec3d) {
        CompoundTag vec3dNbt = NbtUtil.create();
        NbtUtil.putDouble(vec3dNbt, "x", vec3d.m_7096_());
        NbtUtil.putDouble(vec3dNbt, "y", vec3d.m_7098_());
        NbtUtil.putDouble(vec3dNbt, "z", vec3d.m_7094_());
        NbtUtil.put(nbt, key, vec3dNbt);
    }

    public static Vec3 getVec3d(CompoundTag nbt, String key) {
        CompoundTag vec3dNbt = NbtUtil.get(nbt, key);
        return Vec3dUtil.create(NbtUtil.getDouble(vec3dNbt, "x"), NbtUtil.getDouble(vec3dNbt, "y"), NbtUtil.getDouble(vec3dNbt, "z"));
    }

    public static void putItemStack(CompoundTag nbt, String key, ItemStack stack, CompatRegistryLookup registryLookup) {
        CompoundTag stackNbt = NbtUtil.create();
        stack.m_41739_(stackNbt);
        NbtUtil.put(nbt, key, stackNbt);
    }

    public static Optional<ItemStack> getItemStack(CompoundTag nbt, String key, CompatRegistryLookup registryLookup) {
        CompoundTag stackNbt = NbtUtil.get(nbt, key);
        return Optional.ofNullable(ItemStack.m_41712_((CompoundTag)stackNbt));
    }

    public static void putSimpleItemStack(CompoundTag nbt, String key, ItemStack stack) {
        CompoundTag stackNbt = NbtUtil.create();
        NbtUtil.putString(stackNbt, "id", ItemUtil.toID(stack.m_41720_()).toString());
        NbtUtil.putByte(stackNbt, "Count", (byte)ItemStackUtil.getCount(stack));
        CompoundTag tagNbt = NbtUtil.create();
        CompoundTag componentsNbt = NbtUtil.create();
        NbtUtil.put(componentsNbt, "minecraft:custom_data", CustomDataUtil.getOrCreateNbt(stack));
        NbtUtil.put(tagNbt, "components", componentsNbt);
        NbtUtil.put(stackNbt, "tag", tagNbt);
        NbtUtil.put(nbt, key, stackNbt);
    }

    public static Optional<ItemStack> getSimpleItemStack(CompoundTag nbt, String key) {
        CompoundTag componentsNbt;
        CompoundTag tagNbt;
        if (!NbtUtil.has(nbt, key)) {
            return Optional.empty();
        }
        CompoundTag stackNbt = NbtUtil.get(nbt, key);
        if (!NbtUtil.has(stackNbt, "id") || !NbtUtil.has(stackNbt, "Count")) {
            return Optional.empty();
        }
        Item item = ItemUtil.fromId(CompatIdentifier.of(NbtUtil.getString(stackNbt, "id")));
        byte count = NbtUtil.getByte(stackNbt, "Count");
        ItemStack stack = ItemStackUtil.create(item, (int)count);
        if (NbtUtil.has(stackNbt, "tag") && NbtUtil.has(tagNbt = NbtUtil.get(stackNbt, "tag"), "components") && NbtUtil.has(componentsNbt = NbtUtil.get(tagNbt, "components"), "minecraft:custom_data")) {
            CustomDataUtil.setNbt(stack, NbtUtil.get(componentsNbt, "minecraft:custom_data"));
        }
        return Optional.of(stack);
    }

    public static ListTag createNbtList() {
        return new ListTag();
    }

    public static int getIntOrDefault(CompoundTag nbt, String key, int defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getInt(nbt, key);
        }
        return defaultValue;
    }

    public static String getStringOrDefault(CompoundTag nbt, String key, String defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getString(nbt, key);
        }
        return defaultValue;
    }

    public static boolean getBooleanOrDefault(CompoundTag nbt, String key, boolean defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getBoolean(nbt, key);
        }
        return defaultValue;
    }

    public static float getFloatOrDefault(CompoundTag nbt, String key, float defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getFloat(nbt, key);
        }
        return defaultValue;
    }

    public static double getDoubleOrDefault(CompoundTag nbt, String key, double defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getDouble(nbt, key);
        }
        return defaultValue;
    }

    public static long getLongOrDefault(CompoundTag nbt, String key, long defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getLong(nbt, key);
        }
        return defaultValue;
    }

    public static byte getByteOrDefault(CompoundTag nbt, String key, byte defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getByte(nbt, key);
        }
        return defaultValue;
    }

    public static short getShortOrDefault(CompoundTag nbt, String key, short defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getShort(nbt, key);
        }
        return defaultValue;
    }

    public static UUID getUuidOrDefault(CompoundTag nbt, String key, UUID defaultValue) {
        if (NbtUtil.has(nbt, key)) {
            return NbtUtil.getUuid(nbt, key);
        }
        return defaultValue;
    }

    public static Tag getElement(CompoundTag nbt, String key) {
        return nbt.m_128423_(key);
    }

    public static void putElement(CompoundTag nbt, String key, Tag element) {
        nbt.m_128365_(key, element);
    }

    public static void setBlockPosDirect(CompoundTag nbt, BlockPos pos) {
        NbtUtil.putInt(nbt, "x", pos.m_123341_());
        NbtUtil.putInt(nbt, "y", pos.m_123342_());
        NbtUtil.putInt(nbt, "z", pos.m_123343_());
    }

    public static BlockPos getBlockPosDirect(CompoundTag nbt) {
        return PosUtil.flooredBlockPos(NbtUtil.getInt(nbt, "x"), NbtUtil.getInt(nbt, "y"), NbtUtil.getInt(nbt, "z"));
    }

    public static void setVec3iDirect(CompoundTag nbt, Vec3i vec3i) {
        NbtUtil.putInt(nbt, "x", vec3i.m_123341_());
        NbtUtil.putInt(nbt, "y", vec3i.m_123342_());
        NbtUtil.putInt(nbt, "z", vec3i.m_123343_());
    }

    public static Vec3i getVec3iDirect(CompoundTag nbt) {
        return Vec3iUtil.create(NbtUtil.getInt(nbt, "x"), NbtUtil.getInt(nbt, "y"), NbtUtil.getInt(nbt, "z"));
    }

    public static void setVec3dDirect(CompoundTag nbt, Vec3 vec3d) {
        NbtUtil.putDouble(nbt, "x", vec3d.m_7096_());
        NbtUtil.putDouble(nbt, "y", vec3d.m_7098_());
        NbtUtil.putDouble(nbt, "z", vec3d.m_7094_());
    }

    public static Vec3 getVec3dDirect(CompoundTag nbt) {
        return Vec3dUtil.create(NbtUtil.getDouble(nbt, "x"), NbtUtil.getDouble(nbt, "y"), NbtUtil.getDouble(nbt, "z"));
    }

    public static void setVec3iDirect(CompoundTag nbt, int x, int y, int z) {
        NbtUtil.putInt(nbt, "x", x);
        NbtUtil.putInt(nbt, "y", y);
        NbtUtil.putInt(nbt, "z", z);
    }

    public static void setVec3dDirect(CompoundTag nbt, double x, double y, double z) {
        NbtUtil.putDouble(nbt, "x", x);
        NbtUtil.putDouble(nbt, "y", y);
        NbtUtil.putDouble(nbt, "z", z);
    }

    public static String asString(Tag nbt) {
        return nbt.m_7916_();
    }

    public static StringTag createString(String string) {
        return StringTag.m_129297_((String)string);
    }

    public static IntTag createInt(int value) {
        return IntTag.m_128679_((int)value);
    }

    public static FloatTag createFloat(float value) {
        return FloatTag.m_128566_((float)value);
    }

    public static DoubleTag createDouble(double value) {
        return DoubleTag.m_128500_((double)value);
    }

    public static LongTag createLong(long value) {
        return LongTag.m_128882_((long)value);
    }

    public static ByteTag createByte(byte value) {
        return ByteTag.m_128266_((byte)value);
    }

    public static ShortTag createShort(short value) {
        return ShortTag.m_129258_((short)value);
    }

    public static void copyFrom(CompoundTag target, CompoundTag source) {
        target.m_128391_(source);
    }
}

