/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.pitan76.mcpitanlib.api.event.block.AppendPropertiesArgs;
import net.pitan76.mcpitanlib.api.state.property.CompatProperties;
import net.pitan76.mcpitanlib.api.state.property.DirectionProperty;

public class PropertyUtil {
    public static BooleanProperty createBooleanProperty(String name) {
        return BooleanProperty.m_61465_((String)name);
    }

    public static DirectionProperty createDirectionProperty(String name) {
        return DirectionProperty.of(name);
    }

    public static IntegerProperty createIntProperty(String name, int min, int max) {
        return IntegerProperty.m_61631_((String)name, (int)min, (int)max);
    }

    public static <T extends Enum<T>> EnumProperty<T> createEnumProperty(String name, Class<T> type) {
        return EnumProperty.m_61587_((String)name, type);
    }

    public static BlockState with(BlockState state, BooleanProperty property, boolean value) {
        return (BlockState)state.m_61124_((Property)property, (Comparable)Boolean.valueOf(value));
    }

    public static BlockState with(BlockState state, IntegerProperty property, int value) {
        return (BlockState)state.m_61124_((Property)property, (Comparable)Integer.valueOf(value));
    }

    public static BlockState with(BlockState state, DirectionProperty property, Direction value) {
        return property.with(state, value);
    }

    public static boolean get(BlockState state, BooleanProperty property) {
        return (Boolean)state.m_61143_((Property)property);
    }

    public static int get(BlockState state, IntegerProperty property) {
        return (Integer)state.m_61143_((Property)property);
    }

    public static Direction get(BlockState state, DirectionProperty property) {
        return (Direction)property.get(state);
    }

    public static net.pitan76.mcpitanlib.midohra.util.math.Direction getAsMidohra(BlockState state, DirectionProperty property) {
        return net.pitan76.mcpitanlib.midohra.util.math.Direction.of((Direction)property.get(state));
    }

    public static Direction getFacing(BlockState state) {
        return (Direction)PropertyUtil.facing().get(state);
    }

    public static Direction getHorizontalFacing(BlockState state) {
        return (Direction)PropertyUtil.horizontalFacing().get(state);
    }

    public static int getPower(BlockState state) {
        return (Integer)state.m_61143_((Property)PropertyUtil.power());
    }

    public static boolean isPowered(BlockState state) {
        return (Boolean)state.m_61143_((Property)PropertyUtil.powered());
    }

    public static void append(AppendPropertiesArgs args, Property<?> ... properties) {
        args.addProperty(properties);
    }

    public static void appendFacing(AppendPropertiesArgs args) {
        PropertyUtil.facing().apply(args);
    }

    public static void appendHorizontalFacing(AppendPropertiesArgs args) {
        PropertyUtil.horizontalFacing().apply(args);
    }

    public static void appendPower(AppendPropertiesArgs args) {
        args.addProperty(new Property[]{PropertyUtil.power()});
    }

    public static void appendPowered(AppendPropertiesArgs args) {
        args.addProperty(new Property[]{PropertyUtil.powered()});
    }

    public static IntegerProperty power() {
        return BlockStateProperties.f_61426_;
    }

    public static BooleanProperty powered() {
        return BlockStateProperties.f_61448_;
    }

    public static DirectionProperty facing() {
        return CompatProperties.FACING;
    }

    public static DirectionProperty horizontalFacing() {
        return CompatProperties.HORIZONTAL_FACING;
    }

    public static EnumProperty<Direction.Axis> axis() {
        return BlockStateProperties.f_61365_;
    }

    public static EnumProperty<Half> blockHalf() {
        return BlockStateProperties.f_61402_;
    }

    public static EnumProperty<StairsShape> stairShape() {
        return BlockStateProperties.f_61398_;
    }

    public static BooleanProperty lit() {
        return BlockStateProperties.f_61443_;
    }

    public static BooleanProperty waterlogged() {
        return BlockStateProperties.f_61362_;
    }

    public static BooleanProperty attached() {
        return BlockStateProperties.f_61386_;
    }

    public static BooleanProperty hanging() {
        return BlockStateProperties.f_61435_;
    }

    public static BooleanProperty bottom() {
        return BlockStateProperties.f_61427_;
    }

    public static BooleanProperty conditional() {
        return BlockStateProperties.f_61428_;
    }

    public static BooleanProperty inWall() {
        return BlockStateProperties.f_61442_;
    }

    public static BooleanProperty open() {
        return BlockStateProperties.f_61446_;
    }

    public static BooleanProperty occupied() {
        return BlockStateProperties.f_61445_;
    }

    public static boolean contains(BlockState state, Property<?> property) {
        return state.m_61138_(property);
    }
}

