/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.guilib.api.block.entity;

import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.block.TileCreateEvent;
import net.pitan76.mcpitanlib.api.event.container.factory.DisplayNameArgs;
import net.pitan76.mcpitanlib.api.event.container.factory.ExtraDataArgs;
import net.pitan76.mcpitanlib.api.event.tile.TileTickEvent;
import net.pitan76.mcpitanlib.api.gui.v2.ExtendedScreenHandlerFactory;
import net.pitan76.mcpitanlib.api.network.PacketByteUtil;
import net.pitan76.mcpitanlib.api.network.v2.ServerNetworking;
import net.pitan76.mcpitanlib.api.tile.ExtendBlockEntityTicker;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.guilib.api.NetworkDefines;
import net.pitan76.mcpitanlib.guilib.api.block.entity.BlockEntityWithContainer;
import net.pitan76.mcpitanlib.guilib.api.container.ExtendedBlockEntityContainerGui;

public abstract class ExtendedBlockEntityWithContainer
extends BlockEntityWithContainer
implements ExtendedScreenHandlerFactory,
ExtendBlockEntityTicker<ExtendedBlockEntityWithContainer> {
    public ExtendedBlockEntityWithContainer(BlockEntityType<?> type, TileCreateEvent e) {
        super(type, e);
    }

    @Override
    public void tick(TileTickEvent<ExtendedBlockEntityWithContainer> e) {
        if (this.isClient()) {
            return;
        }
        List<Player> players = WorldUtil.getPlayers(Objects.requireNonNull(this.m_58904_()));
        for (Player player : players) {
            if (!player.hasNetworkHandler() || !(player.getCurrentScreenHandler() instanceof ExtendedBlockEntityContainerGui) || ((ExtendedBlockEntityContainerGui)player.getCurrentScreenHandler()).blockEntity != this) continue;
            FriendlyByteBuf buf = PacketByteUtil.create();
            this.sync(player, buf);
            ServerNetworking.send(player, NetworkDefines.SYNC_GUI_WITH_TILE, buf);
        }
    }

    @Override
    public Component getDisplayName(DisplayNameArgs args) {
        if (this.m_58900_() == null) {
            return TextUtil.of("unknown");
        }
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Override
    public void writeExtraData(ExtraDataArgs args) {
        PacketByteUtil.writeBlockPos(args.buf, this.m_58899_());
        this.sync(args.getCompatPlayer(), args.buf);
    }

    public abstract void sync(Player var1, FriendlyByteBuf var2);
}

