/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.midohra.block;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.pitan76.mcpitanlib.api.sound.CompatBlockSoundGroup;
import net.pitan76.mcpitanlib.api.state.property.DirectionProperty;
import net.pitan76.mcpitanlib.api.state.property.IProperty;
import net.pitan76.mcpitanlib.api.util.BlockStateUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.util.math.Direction;

public class BlockState {
    private final net.minecraft.world.level.block.state.BlockState state;
    private BlockWrapper blockWrapper;

    protected BlockState(net.minecraft.world.level.block.state.BlockState state) {
        this.state = state;
    }

    public static BlockState of(net.minecraft.world.level.block.state.BlockState state) {
        return new BlockState(state);
    }

    public static BlockState of(Block block) {
        if (block == null) {
            return BlockState.of((net.minecraft.world.level.block.state.BlockState)null);
        }
        return BlockState.of(BlockStateUtil.getDefaultState(block));
    }

    public boolean isExist() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.toMinecraft() == null;
    }

    public boolean isAir() {
        return this.isEmpty() || BlockStateUtil.isAir(this.toMinecraft());
    }

    public CompatBlockSoundGroup getSoundGroup() {
        return BlockStateUtil.getCompatSoundGroup(this.toMinecraft());
    }

    public BlockWrapper getBlock() {
        if (this.blockWrapper == null) {
            this.blockWrapper = BlockWrapper.of(BlockStateUtil.getBlock(this.toMinecraft()));
        }
        return this.blockWrapper;
    }

    public String getName() {
        return this.getBlock().getName();
    }

    public net.minecraft.world.level.block.state.BlockState toMinecraft() {
        return this.state;
    }

    public <T extends Comparable<T>, V extends T> BlockState with(Property<T> property, V value) {
        return BlockState.of((net.minecraft.world.level.block.state.BlockState)this.toMinecraft().m_61124_(property, value));
    }

    public <T extends Comparable<T>, V extends T> BlockState with(IProperty<T> property, V value) {
        return this.with(property.getProperty(), value);
    }

    public BlockState with(DirectionProperty property, Direction value) {
        return BlockState.of(property.with(this.toMinecraft(), value.toMinecraft()));
    }

    public <T extends Comparable<T>> BlockState cycle(Property<T> property) {
        return BlockState.of((net.minecraft.world.level.block.state.BlockState)this.toMinecraft().m_61122_(property));
    }

    public <T extends Comparable<T>> BlockState cycle(IProperty<T> property) {
        return this.cycle(property.getProperty());
    }

    public BlockState cycle(DirectionProperty property) {
        return BlockState.of(property.cycle(this.toMinecraft()));
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        return (T)this.toMinecraft().m_61143_(property);
    }

    public <T extends Comparable<T>> T get(IProperty<T> property) {
        return this.get(property.getProperty());
    }

    public Direction get(DirectionProperty property) {
        return Direction.of(this.get(property.getProperty()));
    }

    public <T extends Comparable<T>> boolean contains(Property<T> property) {
        return this.toMinecraft().m_61138_(property);
    }

    public <T extends Comparable<T>> boolean contains(IProperty<T> property) {
        return this.contains(property.getProperty());
    }

    public boolean contains(DirectionProperty property) {
        return this.contains(property.getProperty());
    }
}

