/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.util.BlockUtil;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class PostMineEvent
extends BaseEvent {
    public ItemStack stack;
    public Level world;
    public BlockState state;
    public BlockPos pos;
    public LivingEntity miner;

    public PostMineEvent(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        this.stack = stack;
        this.world = world;
        this.state = state;
        this.pos = pos;
        this.miner = miner;
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getWorld() {
        return this.world;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public LivingEntity getMiner() {
        return this.miner;
    }

    public BlockEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.pos);
    }

    public boolean isClient() {
        return this.world.isClientSide;
    }

    public boolean stateIsIn(TagKey<Block> tagKey) {
        return BlockUtil.isIn(this.state.getBlock(), tagKey);
    }

    public boolean stateIsOf(Block block) {
        return BlockUtil.isEqual(this.state.getBlock(), block);
    }

    public void damageStack(int amount, EquipmentSlot slot) {
        this.stack.hurtAndBreak(amount, this.miner, entity -> entity.broadcastBreakEvent(slot));
    }

    public void damageStack(int amount, ArmorEquipmentType type) {
        this.stack.hurtAndBreak(amount, this.miner, entity -> entity.broadcastBreakEvent(type.getSlot()));
    }

    public void damageStack(int amount) {
        this.stack.hurtAndBreak(amount, this.miner, entity -> entity.broadcastBreakEvent(EquipmentSlot.MAINHAND));
    }

    public boolean isPlayer() {
        return this.miner instanceof Player;
    }

    public net.pitan76.mcpitanlib.api.entity.Player getPlayer() {
        if (this.isPlayer()) {
            return new net.pitan76.mcpitanlib.api.entity.Player((Player)this.miner);
        }
        return null;
    }

    public boolean isCreative() {
        return this.isPlayer() && this.getPlayer().isCreative();
    }

    public boolean isSneaking() {
        return this.miner.isShiftKeyDown();
    }

    public ItemStack getMainHandStack() {
        return this.miner.getMainHandItem();
    }
}

