/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.item;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.pitan76.mcpitanlib.api.item.ArmorEquipmentType;

public interface CompatibleArmorMaterial {
    public int getDurability(ArmorEquipmentType var1);

    public int getProtection(ArmorEquipmentType var1);

    public int getEnchantability();

    public SoundEvent getEquipSound();

    public Ingredient getRepairIngredient();

    default public String getName() {
        return this.getId().getPath();
    }

    public ResourceLocation getId();

    public float getToughness();

    public float getKnockbackResistance();

    @Deprecated
    default public ArmorMaterial build() {
        return new ArmorMaterial(){

            public int getDurabilityForType(ArmorItem.Type type) {
                return CompatibleArmorMaterial.this.getDurability(ArmorEquipmentType.of(type));
            }

            public int getDefenseForType(ArmorItem.Type type) {
                return CompatibleArmorMaterial.this.getProtection(ArmorEquipmentType.of(type));
            }

            public int getEnchantmentValue() {
                return CompatibleArmorMaterial.this.getEnchantability();
            }

            public SoundEvent getEquipSound() {
                return CompatibleArmorMaterial.this.getEquipSound();
            }

            public Ingredient getRepairIngredient() {
                return CompatibleArmorMaterial.this.getRepairIngredient();
            }

            public String getName() {
                return CompatibleArmorMaterial.this.getName();
            }

            public float getToughness() {
                return CompatibleArmorMaterial.this.getToughness();
            }

            public float getKnockbackResistance() {
                return CompatibleArmorMaterial.this.getKnockbackResistance();
            }
        };
    }
}

