/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.network;

import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerNetworking {
    public static void send(ServerPlayer player, ResourceLocation identifier, FriendlyByteBuf buf) {
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)identifier, (FriendlyByteBuf)buf);
    }

    public static void send(Iterable<ServerPlayer> players, ResourceLocation identifier, FriendlyByteBuf buf) {
        NetworkManager.sendToPlayers(players, (ResourceLocation)identifier, (FriendlyByteBuf)buf);
    }

    public static void sendAll(MinecraftServer server, ResourceLocation identifier, FriendlyByteBuf buf) {
        ServerNetworking.send(server.getPlayerList().getPlayers(), identifier, buf);
    }

    public static void registerReceiver(ResourceLocation identifier, ServerNetworkHandler handler) {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)identifier, (buf, context) -> handler.receive(context.getPlayer().getServer(), (ServerPlayer)context.getPlayer(), buf));
    }

    public static void registerS2CPayloadType(ResourceLocation identifier) {
    }

    @FunctionalInterface
    public static interface ServerNetworkHandler {
        public void receive(MinecraftServer var1, ServerPlayer var2, FriendlyByteBuf var3);
    }
}

