/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.transfer.fluid.v1.neoforge;

import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidStorage;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.IFluidVariant;
import net.pitan76.mcpitanlib.api.transfer.fluid.v1.neoforge.NeoForgeFluidVariant;

public class NeoForgeFluidStorage
implements IFluidStorage {
    public final FluidTank storage;
    public Runnable onChange;

    public NeoForgeFluidStorage(FluidTank storage, Runnable onChange) {
        this.storage = storage;
        this.onChange = onChange;
    }

    @Override
    public long getAmount() {
        return this.storage.getFluidAmount();
    }

    @Override
    public long getCapacity() {
        return this.storage.getCapacity();
    }

    @Override
    public IFluidVariant getResource() {
        return new NeoForgeFluidVariant(this.storage.getFluid());
    }

    @Override
    public void setResource(IFluidVariant variant) {
        this.storage.setFluid(((NeoForgeFluidVariant)variant).raw);
    }

    @Override
    public boolean isResourceBlank() {
        return this.storage.isEmpty();
    }

    @Override
    public long insert(IFluidVariant variant, long maxAmount, boolean simulate) {
        if (simulate) {
            return this.storage.fill(((NeoForgeFluidVariant)variant).raw.copyWithAmount((int)maxAmount), IFluidHandler.FluidAction.SIMULATE);
        }
        this.onChange.run();
        return this.storage.fill(((NeoForgeFluidVariant)variant).raw.copyWithAmount((int)maxAmount), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public long extract(IFluidVariant variant, long maxAmount, boolean simulate) {
        if (simulate) {
            return this.storage.drain(((NeoForgeFluidVariant)variant).raw.copyWithAmount((int)maxAmount), IFluidHandler.FluidAction.SIMULATE).getAmount();
        }
        this.onChange.run();
        return this.storage.drain(((NeoForgeFluidVariant)variant).raw.copyWithAmount((int)maxAmount), IFluidHandler.FluidAction.EXECUTE).getAmount();
    }

    @Override
    public void writeNbt(WriteNbtArgs args) {
        this.storage.writeToNBT(args.nbt);
    }

    @Override
    public void readNbt(WriteNbtArgs args) {
        this.storage.readFromNBT(args.nbt);
    }
}

