/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.BlockEntityTypeUtil;
import net.pitan76.mcpitanlib.api.util.NbtUtil;

public class BlockEntityDataUtil {
    public static CompoundTag getBlockEntityNbt(ItemStack stack) {
        if (!BlockEntityDataUtil.hasBlockEntityNbt(stack)) {
            return NbtUtil.create();
        }
        return stack.getTagElement("BlockEntityTag");
    }

    public static void setBlockEntityNbt(ItemStack stack, CompoundTag nbt) {
        stack.addTagElement("BlockEntityTag", (Tag)nbt);
    }

    public static boolean hasBlockEntityNbt(ItemStack stack) {
        if (!stack.hasTag()) {
            return false;
        }
        return NbtUtil.has(stack.getTag(), "BlockEntityTag");
    }

    public static void readCompatBlockEntityNbtFromStack(ItemStack stack, CompatBlockEntity blockEntity) {
        CompoundTag nbt = BlockEntityDataUtil.getBlockEntityNbt(stack);
        blockEntity.readNbt(new ReadNbtArgs(nbt));
    }

    public static void writeCompatBlockEntityNbtToStack(ItemStack stack, CompatBlockEntity blockEntity) {
        CompoundTag nbt = BlockEntityDataUtil.getBlockEntityNbt(stack);
        blockEntity.writeNbt(new WriteNbtArgs(nbt));
        NbtUtil.set(nbt, "id", BlockEntityTypeUtil.toID(blockEntity.getType()).toString());
        BlockEntityDataUtil.setBlockEntityNbt(stack, nbt);
    }

    public static void removeBlockEntityNbt(ItemStack stack) {
        stack.removeTagKey("BlockEntityTag");
    }
}

