/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;

public class EntityTypeUtil {
    public static ResourceLocation toID(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static EntityType<?> fromId(ResourceLocation identifier) {
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(identifier);
    }

    public static boolean isExist(ResourceLocation identifier) {
        return BuiltInRegistries.ENTITY_TYPE.containsKey(identifier);
    }

    public static CompatIdentifier toCompatID(EntityType<?> entityType) {
        return CompatIdentifier.fromMinecraft(EntityTypeUtil.toID(entityType));
    }

    public static EntityType<?> fromId(CompatIdentifier identifier) {
        return EntityTypeUtil.fromId(identifier.toMinecraft());
    }

    public static boolean isExist(CompatIdentifier identifier) {
        return EntityTypeUtil.isExist(identifier.toMinecraft());
    }

    public static int getRawId(EntityType<?> type) {
        return BuiltInRegistries.ENTITY_TYPE.getId(type);
    }

    public static EntityType<?> fromIndex(int index) {
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.byId(index);
    }

    public static Component getName(EntityType<?> entityType) {
        return entityType.getDescription();
    }

    public static String getTranslationKey(EntityType<?> entityType) {
        return entityType.getDescriptionId();
    }
}

