/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.block;

import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;

public final class CompatibleMaterial {
    public static final CompatibleMaterial AIR = new Builder(MaterialColor.f_76398_).allowsMovement().lightPassesThrough().notSolid().replaceable().material(Material.f_76296_).build();
    public static final CompatibleMaterial STRUCTURE_VOID = new Builder(MaterialColor.f_76398_).allowsMovement().lightPassesThrough().notSolid().replaceable().material(Material.f_76297_).build();
    public static final CompatibleMaterial PORTAL = new Builder(MaterialColor.f_76398_).allowsMovement().lightPassesThrough().notSolid().blocksPistons().material(Material.f_76298_).build();
    public static final CompatibleMaterial CARPET = new Builder(MaterialColor.f_76401_).allowsMovement().lightPassesThrough().notSolid().burnable().material(Material.f_76299_).build();
    public static final CompatibleMaterial PLANT = new Builder(MaterialColor.f_76405_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().material(Material.f_76300_).build();
    public static final CompatibleMaterial UNDERWATER_PLANT = new Builder(MaterialColor.f_76410_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().material(Material.f_76301_).build();
    public static final CompatibleMaterial REPLACEABLE_PLANT = new Builder(MaterialColor.f_76405_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().burnable().material(Material.f_76302_).build();
    public static final CompatibleMaterial NETHER_SHOOTS = new Builder(MaterialColor.f_76405_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.f_76303_).build();
    public static final CompatibleMaterial REPLACEABLE_UNDERWATER_PLANT = new Builder(MaterialColor.f_76410_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.f_76304_).build();
    public static final CompatibleMaterial WATER = new Builder(MaterialColor.f_76410_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().material(Material.f_76305_).build();
    public static final CompatibleMaterial BUBBLE_COLUMN = new Builder(MaterialColor.f_76410_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().material(Material.f_76306_).build();
    public static final CompatibleMaterial LAVA = new Builder(MaterialColor.f_76402_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().liquid().material(Material.f_76307_).build();
    public static final CompatibleMaterial SNOW_LAYER = new Builder(MaterialColor.f_76406_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.f_76308_).build();
    public static final CompatibleMaterial FIRE = new Builder(MaterialColor.f_76398_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().replaceable().material(Material.f_76309_).build();
    public static final CompatibleMaterial DECORATION = new Builder(MaterialColor.f_76398_).allowsMovement().lightPassesThrough().notSolid().destroyedByPiston().material(Material.f_76310_).build();
    public static final CompatibleMaterial COBWEB = new Builder(MaterialColor.f_76401_).allowsMovement().lightPassesThrough().destroyedByPiston().material(Material.f_76311_).build();
    public static final CompatibleMaterial SCULK = new Builder(MaterialColor.f_76365_).material(Material.f_164533_).build();
    public static final CompatibleMaterial REDSTONE_LAMP = new Builder(MaterialColor.f_76398_).material(Material.f_76312_).build();
    public static final CompatibleMaterial ORGANIC_PRODUCT = new Builder(MaterialColor.f_76407_).material(Material.f_76313_).build();
    public static final CompatibleMaterial SOIL = new Builder(MaterialColor.f_76408_).material(Material.f_76314_).build();
    public static final CompatibleMaterial SOLID_ORGANIC = new Builder(MaterialColor.f_76399_).material(Material.f_76315_).build();
    public static final CompatibleMaterial DENSE_ICE = new Builder(MaterialColor.f_76403_).material(Material.f_76316_).build();
    public static final CompatibleMaterial AGGREGATE = new Builder(MaterialColor.f_76400_).material(Material.f_76317_).build();
    public static final CompatibleMaterial SPONGE = new Builder(MaterialColor.f_76416_).material(Material.f_76318_).build();
    public static final CompatibleMaterial SHULKER_BOX = new Builder(MaterialColor.f_76422_).material(Material.f_76319_).build();
    public static final CompatibleMaterial WOOD = new Builder(MaterialColor.f_76411_).burnable().material(Material.f_76320_).build();
    public static final CompatibleMaterial NETHER_WOOD = new Builder(MaterialColor.f_76411_).material(Material.f_76321_).build();
    public static final CompatibleMaterial BAMBOO_SAPLING = new Builder(MaterialColor.f_76411_).burnable().destroyedByPiston().allowsMovement().material(Material.f_76270_).build();
    public static final CompatibleMaterial BAMBOO = new Builder(MaterialColor.f_76411_).burnable().destroyedByPiston().material(Material.f_76271_).build();
    public static final CompatibleMaterial WOOL = new Builder(MaterialColor.f_76401_).burnable().material(Material.f_76272_).build();
    public static final CompatibleMaterial TNT = new Builder(MaterialColor.f_76402_).burnable().lightPassesThrough().material(Material.f_76273_).build();
    public static final CompatibleMaterial LEAVES = new Builder(MaterialColor.f_76405_).burnable().lightPassesThrough().destroyedByPiston().material(Material.f_76274_).build();
    public static final CompatibleMaterial GLASS = new Builder(MaterialColor.f_76398_).lightPassesThrough().material(Material.f_76275_).build();
    public static final CompatibleMaterial ICE = new Builder(MaterialColor.f_76403_).lightPassesThrough().material(Material.f_76276_).build();
    public static final CompatibleMaterial CACTUS = new Builder(MaterialColor.f_76405_).lightPassesThrough().destroyedByPiston().material(Material.f_76277_).build();
    public static final CompatibleMaterial STONE = new Builder(MaterialColor.f_76409_).material(Material.f_76278_).build();
    public static final CompatibleMaterial METAL = new Builder(MaterialColor.f_76404_).material(Material.f_76279_).build();
    public static final CompatibleMaterial SNOW_BLOCK = new Builder(MaterialColor.f_76406_).material(Material.f_76280_).build();
    public static final CompatibleMaterial REPAIR_STATION = new Builder(MaterialColor.f_76404_).blocksPistons().material(Material.f_76281_).build();
    public static final CompatibleMaterial BARRIER = new Builder(MaterialColor.f_76398_).blocksPistons().material(Material.f_76282_).build();
    public static final CompatibleMaterial PISTON = new Builder(MaterialColor.f_76409_).blocksPistons().material(Material.f_76283_).build();
    public static final CompatibleMaterial MOSS_BLOCK = new Builder(MaterialColor.f_76405_).destroyedByPiston().material(Material.f_164530_).build();
    public static final CompatibleMaterial GOURD = new Builder(MaterialColor.f_76405_).destroyedByPiston().material(Material.f_76285_).build();
    public static final CompatibleMaterial EGG = new Builder(MaterialColor.f_76405_).destroyedByPiston().material(Material.f_76286_).build();
    public static final CompatibleMaterial CAKE = new Builder(MaterialColor.f_76398_).destroyedByPiston().material(Material.f_76287_).build();
    public static final CompatibleMaterial AMETHYST = new Builder(MaterialColor.f_76422_).material(Material.f_164531_).build();
    public static final CompatibleMaterial POWDER_SNOW = new Builder(MaterialColor.f_76406_).notSolid().allowsMovement().material(Material.f_164532_).build();
    private final MaterialColor color;
    private final PushReaction pistonBehavior;
    private final boolean burnable;
    private final boolean liquid;
    private final boolean replaceable;
    private final boolean solid;
    private Material material;

    public CompatibleMaterial(MaterialColor color, boolean liquid, boolean solid, boolean burnable, boolean replaceable, PushReaction pistonBehavior) {
        this.color = color;
        this.liquid = liquid;
        this.solid = solid;
        this.burnable = burnable;
        this.replaceable = replaceable;
        this.pistonBehavior = pistonBehavior;
        this.material = Material.f_76278_;
    }

    private CompatibleMaterial(Material material, MaterialColor color, boolean liquid, boolean solid, boolean burnable, boolean replaceable, PushReaction pistonBehavior) {
        this(material.m_76339_(), material.m_76332_(), material.m_76333_(), material.m_76335_(), material.m_76336_(), material.m_76338_());
        this.material = material;
    }

    @Deprecated
    public Material getMaterial() {
        return this.material;
    }

    public boolean isLiquid() {
        return this.liquid;
    }

    public boolean isSolid() {
        return this.solid;
    }

    public boolean isBurnable() {
        return this.burnable;
    }

    public boolean isReplaceable() {
        return this.replaceable;
    }

    public PushReaction getPistonBehavior() {
        return this.pistonBehavior;
    }

    public MaterialColor getColor() {
        return this.color;
    }

    public static class Builder {
        private PushReaction pistonBehavior;
        private boolean blocksMovement = true;
        private boolean burnable;
        private boolean liquid;
        private boolean replaceable;
        private boolean solid = true;
        private final MaterialColor color;
        private boolean blocksLight = true;
        private Material material = Material.f_76278_;

        public Builder(MaterialColor color) {
            this.pistonBehavior = PushReaction.NORMAL;
            this.color = color;
        }

        public Builder liquid() {
            this.liquid = true;
            return this;
        }

        public Builder notSolid() {
            this.solid = false;
            return this;
        }

        public Builder allowsMovement() {
            this.blocksMovement = false;
            return this;
        }

        Builder lightPassesThrough() {
            this.blocksLight = false;
            return this;
        }

        protected Builder burnable() {
            this.burnable = true;
            return this;
        }

        public Builder replaceable() {
            this.replaceable = true;
            return this;
        }

        protected Builder destroyedByPiston() {
            this.pistonBehavior = PushReaction.DESTROY;
            return this;
        }

        protected Builder blocksPistons() {
            this.pistonBehavior = PushReaction.BLOCK;
            return this;
        }

        protected Builder material(Material material) {
            this.material = material;
            return this;
        }

        public CompatibleMaterial build() {
            return new CompatibleMaterial(this.material, this.color, this.liquid, this.solid, this.burnable, this.replaceable, this.pistonBehavior);
        }
    }
}

