/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.render.block.entity.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.pitan76.mcpitanlib.api.client.render.CompatRenderLayer;
import net.pitan76.mcpitanlib.api.client.render.DrawObjectMV;
import net.pitan76.mcpitanlib.api.tile.CompatBlockEntity;
import net.pitan76.mcpitanlib.api.util.MathUtil;
import net.pitan76.mcpitanlib.api.util.client.ClientUtil;
import net.pitan76.mcpitanlib.api.util.client.MatrixStackUtil;

public class BlockEntityRenderEvent<T extends CompatBlockEntity> {
    public T blockEntity;
    public float tickDelta;
    public PoseStack matrices;
    public MultiBufferSource vertexConsumers;
    int light;
    int overlay;
    public Matrix4f matrix4f;
    public Matrix3f matrix3f;

    public BlockEntityRenderEvent(T blockEntity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        this.blockEntity = blockEntity;
        this.tickDelta = tickDelta;
        this.matrices = matrices;
        this.vertexConsumers = vertexConsumers;
        this.light = light;
        this.overlay = overlay;
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public PoseStack getMatrices() {
        return this.matrices;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public int getLight() {
        return this.light;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public VertexConsumer getVertexConsumer(RenderType layer) {
        return this.vertexConsumers.m_6299_(layer);
    }

    public VertexConsumer getVertexConsumer(CompatRenderLayer layer) {
        return this.getVertexConsumer(layer.raw());
    }

    public MultiBufferSource getVertexConsumers() {
        return this.vertexConsumers;
    }

    public void push() {
        MatrixStackUtil.push(this.matrices);
    }

    public void translate(double x, double y, double z) {
        MatrixStackUtil.translate(this.matrices, x, y, z);
    }

    public void pop() {
        MatrixStackUtil.pop(this.matrices);
    }

    public void multiply(MathUtil.RotationAxisType type, float deg) {
        MatrixStackUtil.multiply(this.matrices, type, deg);
    }

    public void scale(float x, float y, float z) {
        MatrixStackUtil.scale(this.matrices, x, y, z);
    }

    public ItemRenderer getItemRenderer() {
        return ClientUtil.getItemRenderer();
    }

    public boolean isRemoved() {
        return this.blockEntity.m_58901_();
    }

    public DrawObjectMV getDrawObject(CompatRenderLayer layer) {
        return new DrawObjectMV(this.getMatrices(), this.getVertexConsumer(layer));
    }

    public Matrix4f getMatrix4f() {
        if (this.matrix4f == null) {
            this.matrix4f = this.matrices.m_85850_().m_85861_();
        }
        return this.matrix4f;
    }

    public Matrix3f getMatrix3f() {
        if (this.matrix3f == null) {
            this.matrix3f = this.matrices.m_85850_().m_85864_();
        }
        return this.matrix3f;
    }

    public BlockPos getPos() {
        return ((CompatBlockEntity)((Object)this.blockEntity)).callGetPos();
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getPos());
    }
}

