/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.event.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.event.BaseEvent;
import net.pitan76.mcpitanlib.api.util.CompatActionResult;
import net.pitan76.mcpitanlib.api.util.WorldUtil;
import net.pitan76.mcpitanlib.midohra.block.BlockWrapper;
import net.pitan76.mcpitanlib.midohra.block.entity.BlockEntityWrapper;
import net.pitan76.mcpitanlib.midohra.world.IWorldView;
import net.pitan76.mcpitanlib.midohra.world.World;
import org.jetbrains.annotations.Nullable;

public class ItemUseOnBlockEvent
extends BaseEvent {
    public Player player;
    public InteractionHand hand;
    public BlockHitResult hit;
    public ItemStack stack;
    public Level world;
    public BlockPos blockPos;

    public ItemUseOnBlockEvent(net.minecraft.world.entity.player.Player player, InteractionHand hand, BlockHitResult hit) {
        this(player.m_183503_(), player, hand, player.m_21120_(hand), hit);
    }

    public ItemUseOnBlockEvent(Level world, @Nullable net.minecraft.world.entity.player.Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit) {
        if (player != null) {
            this.player = new Player(player);
        }
        this.hand = hand;
        this.hit = hit;
        this.stack = stack;
        this.world = world;
        this.blockPos = hit.m_82425_();
    }

    public ItemUseOnBlockEvent(Player player, InteractionHand hand, BlockHitResult hit) {
        this(player.getWorld(), player.getEntity(), hand, player.getStackInHand(hand), hit);
    }

    public UseOnContext toIUC() {
        return new UseOnContext(this.player.getPlayerEntity(), this.hand, this.hit);
    }

    public boolean isClient() {
        return this.world.m_5776_();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockHitResult getHit() {
        return this.hit;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public CompatActionResult success() {
        return CompatActionResult.SUCCESS;
    }

    public CompatActionResult fail() {
        return CompatActionResult.FAIL;
    }

    public CompatActionResult pass() {
        return CompatActionResult.PASS;
    }

    public CompatActionResult consume() {
        return CompatActionResult.CONSUME;
    }

    public BlockEntity getBlockEntity() {
        return WorldUtil.getBlockEntity(this.world, this.blockPos);
    }

    public boolean hasBlockEntity() {
        return WorldUtil.hasBlockEntity(this.world, this.blockPos);
    }

    public BlockState getBlockState() {
        return WorldUtil.getBlockState(this.world, this.blockPos);
    }

    public Vec3 getPos() {
        return this.hit.m_82450_();
    }

    public Direction getSide() {
        return this.hit.m_82434_();
    }

    public World getMidohraWorld() {
        return World.of(this.world);
    }

    public IWorldView getWorldView() {
        return this.getMidohraWorld();
    }

    public net.pitan76.mcpitanlib.midohra.block.BlockState getMidohraState() {
        return net.pitan76.mcpitanlib.midohra.block.BlockState.of(this.getBlockState());
    }

    public net.pitan76.mcpitanlib.midohra.util.math.BlockPos getMidohraPos() {
        return net.pitan76.mcpitanlib.midohra.util.math.BlockPos.of(this.getBlockPos());
    }

    public BlockWrapper getBlockWrapper() {
        return this.getMidohraState().getBlock();
    }

    public BlockEntityWrapper getBlockEntityWrapper() {
        return BlockEntityWrapper.of(this.getBlockEntity());
    }
}

