/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.level.Level;
import net.pitan76.mcpitanlib.api.entity.Player;
import net.pitan76.mcpitanlib.api.util.PlayerUtil;
import net.pitan76.mcpitanlib.api.util.ServerUtil;

public class PlayerManagerUtil {
    public static Player getPlayerByUUID(MinecraftServer server, UUID uuid) {
        return PlayerUtil.getPlayerByUUID(server, uuid);
    }

    public static Player getPlayerByName(MinecraftServer server, String name) {
        return PlayerUtil.getPlayerByName(server, name);
    }

    public static List<Player> getPlayersByIP(MinecraftServer server, String ip) {
        return PlayerUtil.getPlayersByIP(server, ip);
    }

    public static List<Player> getPlayers(MinecraftServer server) {
        return PlayerUtil.getPlayers(server);
    }

    public static List<Player> getPlayers(Level world) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (net.minecraft.world.entity.player.Player p : world.m_6907_()) {
            players.add(new Player(p));
        }
        return players;
    }

    public static Player getPlayerByUUID(Level world, UUID uuid) {
        return PlayerUtil.getPlayerByUUID(world, uuid);
    }

    public static Player getPlayerByName(Level world, String name) {
        return PlayerUtil.getPlayerByName(world, name);
    }

    public static PlayerList getPlayerManager(MinecraftServer server) {
        return ServerUtil.getPlayerManager(server);
    }

    public static PlayerList getPlayerManager(Level world) {
        return PlayerManagerUtil.getPlayerManager(world.m_142572_());
    }

    public static boolean hasPlayerByUUID(PlayerList playerManager, UUID uuid) {
        return playerManager.m_11259_(uuid) != null;
    }

    public static boolean hasPlayerByName(PlayerList playerManager, String name) {
        return playerManager.m_11255_(name) != null;
    }

    public static boolean hasPlayerByIP(PlayerList playerManager, String ip) {
        return !playerManager.m_11282_(ip).isEmpty();
    }

    public static boolean hasPlayerByUUID(MinecraftServer server, UUID uuid) {
        return PlayerManagerUtil.hasPlayerByUUID(PlayerManagerUtil.getPlayerManager(server), uuid);
    }

    public static boolean hasPlayerByName(MinecraftServer server, String name) {
        return PlayerManagerUtil.hasPlayerByName(PlayerManagerUtil.getPlayerManager(server), name);
    }

    public static boolean hasPlayerByIP(MinecraftServer server, String ip) {
        return PlayerManagerUtil.hasPlayerByIP(PlayerManagerUtil.getPlayerManager(server), ip);
    }

    public static boolean hasPlayerByUUID(Level world, UUID uuid) {
        return PlayerManagerUtil.hasPlayerByUUID(PlayerManagerUtil.getPlayerManager(world), uuid);
    }

    public static boolean hasPlayerByName(Level world, String name) {
        return PlayerManagerUtil.hasPlayerByName(PlayerManagerUtil.getPlayerManager(world), name);
    }

    public static boolean hasPlayerByIP(Level world, String ip) {
        return PlayerManagerUtil.hasPlayerByIP(PlayerManagerUtil.getPlayerManager(world), ip);
    }
}

