/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class CraftingRecipeInputUtil {
    public static Optional<CraftingContainer> get(CompatRecipeInput<?> input) {
        if (input.getInput() instanceof CraftingContainer) {
            return Optional.of((CraftingContainer)input.getInput());
        }
        return Optional.empty();
    }

    public static CompatRecipeInput<?> create(CraftingContainer input) {
        return new CompatRecipeInput<CraftingContainer>(input);
    }

    public static CompatRecipeInput<?> create(int width, int height, List<net.minecraft.world.item.ItemStack> stacks) {
        CraftingContainer inventory = new CraftingContainer(null, width, height);
        int size = stacks.size();
        for (int i = 0; i < size; ++i) {
            inventory.m_6836_(i, stacks.get(i));
        }
        return new CompatRecipeInput<CraftingContainer>(inventory);
    }

    public static net.minecraft.world.item.ItemStack getStack(CraftingContainer input, int x, int y) {
        return input.m_8020_(x + y * input.m_39347_());
    }

    public static net.minecraft.world.item.ItemStack getStack(CompatRecipeInput<?> input, int x, int y) {
        Optional<CraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return ItemStackUtil.empty();
        }
        return CraftingRecipeInputUtil.getStack(recipeInput.get(), x, y);
    }

    public static ItemStack getMidohraStack(CompatRecipeInput<?> input, int x, int y) {
        return ItemStack.of(CraftingRecipeInputUtil.getStack(input, x, y));
    }

    public static StackedContents getRecipeMatcher(CraftingContainer input) {
        return null;
    }

    public static StackedContents getRecipeMatcher(CompatRecipeInput<?> input) {
        Optional<CraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getRecipeMatcher(recipeInput.get());
    }

    public static List<net.minecraft.world.item.ItemStack> getStacks(CraftingContainer input) {
        ArrayList<net.minecraft.world.item.ItemStack> stacks = new ArrayList<net.minecraft.world.item.ItemStack>();
        int size = input.m_6643_();
        for (int i = 0; i < size; ++i) {
            stacks.add(input.m_8020_(i));
        }
        return stacks;
    }

    public static List<net.minecraft.world.item.ItemStack> getStacks(CompatRecipeInput<?> input) {
        Optional<CraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getStacks(recipeInput.get());
    }

    public static int getWidth(CraftingContainer input) {
        return input.m_39347_();
    }

    public static int getWidth(CompatRecipeInput<?> input) {
        Optional<CraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getWidth(recipeInput.get());
    }

    public static int getHeight(CraftingContainer input) {
        return input.m_39346_();
    }

    public static int getHeight(CompatRecipeInput<?> input) {
        Optional<CraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getHeight(recipeInput.get());
    }

    public static int getStackCount(CraftingContainer input) {
        return input.m_6643_();
    }

    public static int getStackCount(CompatRecipeInput<?> input) {
        Optional<CraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getStackCount(recipeInput.get());
    }
}

