/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.client.event.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.pitan76.mcpitanlib.api.client.event.listener.BeforeBlockOutlineEvent;
import net.pitan76.mcpitanlib.api.client.event.listener.BeforeBlockOutlineListener;
import net.pitan76.mcpitanlib.api.client.event.listener.WorldRenderContext;
import net.pitan76.mcpitanlib.api.client.event.listener.WorldRenderContextListener;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="mcpitanlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WorldRenderRegistryImpl {
    public static List<BeforeBlockOutlineListener> beforeBlockOutlineListeners = new ArrayList<BeforeBlockOutlineListener>();
    public static List<WorldRenderContextListener> worldRenderAfterLevelListeners = new ArrayList<WorldRenderContextListener>();

    @SubscribeEvent
    public static void renderOutlineEventBlock(final RenderHighlightEvent.Block event) {
        for (BeforeBlockOutlineListener listener : beforeBlockOutlineListeners) {
            boolean eventContinue = listener.beforeBlockOutline(new BeforeBlockOutlineEvent(new WorldRenderContext(){

                @Override
                public LevelRenderer getWorldRenderer() {
                    return event.getLevelRenderer();
                }

                @Override
                public PoseStack getMatrixStack() {
                    return event.getPoseStack();
                }

                @Override
                public float getTickDelta() {
                    return event.getPartialTick();
                }

                @Override
                public Camera getCamera() {
                    return event.getCamera();
                }

                @Override
                public GameRenderer getGameRenderer() {
                    return Minecraft.m_91087_().f_91063_;
                }

                @Override
                public LightTexture getLightmapTextureManager() {
                    return Minecraft.m_91087_().f_91063_.m_109154_();
                }

                @Override
                @Deprecated
                public Matrix4f getProjectionMatrix() {
                    return null;
                }

                @Override
                public ClientLevel getWorld() {
                    return Minecraft.m_91087_().f_91073_;
                }

                @Override
                @Deprecated
                public boolean isAdvancedTranslucency() {
                    return event.getLevelRenderer().m_109825_();
                }

                @Override
                public MultiBufferSource getConsumers() {
                    return event.getMultiBufferSource();
                }

                @Override
                public Frustum getFrustum() {
                    return event.getLevelRenderer().getFrustum();
                }
            }, (HitResult)event.getTarget()));
            if (eventContinue) continue;
            event.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public static void renderOutlineEvent(final RenderHighlightEvent.Entity event) {
        for (BeforeBlockOutlineListener listener : beforeBlockOutlineListeners) {
            listener.beforeBlockOutline(new BeforeBlockOutlineEvent(new WorldRenderContext(){

                @Override
                public LevelRenderer getWorldRenderer() {
                    return event.getLevelRenderer();
                }

                @Override
                public PoseStack getMatrixStack() {
                    return event.getPoseStack();
                }

                @Override
                public float getTickDelta() {
                    return event.getPartialTick();
                }

                @Override
                public Camera getCamera() {
                    return event.getCamera();
                }

                @Override
                public GameRenderer getGameRenderer() {
                    return Minecraft.m_91087_().f_91063_;
                }

                @Override
                public LightTexture getLightmapTextureManager() {
                    return Minecraft.m_91087_().f_91063_.m_109154_();
                }

                @Override
                @Deprecated
                public Matrix4f getProjectionMatrix() {
                    return null;
                }

                @Override
                public ClientLevel getWorld() {
                    return Minecraft.m_91087_().f_91073_;
                }

                @Override
                @Deprecated
                public boolean isAdvancedTranslucency() {
                    return event.getLevelRenderer().m_109825_();
                }

                @Override
                public MultiBufferSource getConsumers() {
                    return event.getMultiBufferSource();
                }

                @Override
                public Frustum getFrustum() {
                    return event.getLevelRenderer().getFrustum();
                }
            }, (HitResult)event.getTarget()));
        }
    }

    @SubscribeEvent
    public static void registerWorldRenderAfterLevel(final RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
            return;
        }
        for (WorldRenderContextListener listener : worldRenderAfterLevelListeners) {
            listener.render(new WorldRenderContext(){

                @Override
                public LevelRenderer getWorldRenderer() {
                    return event.getLevelRenderer();
                }

                @Override
                public PoseStack getMatrixStack() {
                    return event.getPoseStack();
                }

                @Override
                public float getTickDelta() {
                    return event.getPartialTick();
                }

                @Override
                public Camera getCamera() {
                    return event.getCamera();
                }

                @Override
                public GameRenderer getGameRenderer() {
                    return Minecraft.m_91087_().f_91063_;
                }

                @Override
                public LightTexture getLightmapTextureManager() {
                    return Minecraft.m_91087_().f_91063_.m_109154_();
                }

                @Override
                @Deprecated
                public Matrix4f getProjectionMatrix() {
                    return event.getProjectionMatrix();
                }

                @Override
                public ClientLevel getWorld() {
                    return Minecraft.m_91087_().f_91073_;
                }

                @Override
                @Deprecated
                public boolean isAdvancedTranslucency() {
                    return event.getLevelRenderer().m_109825_();
                }

                @Override
                public MultiBufferSource getConsumers() {
                    return Minecraft.m_91087_().m_91269_().m_110109_();
                }

                @Override
                public Frustum getFrustum() {
                    return event.getLevelRenderer().getFrustum();
                }
            });
        }
    }

    public static void registerWorldRenderBeforeBlockOutline(BeforeBlockOutlineListener listener) {
        beforeBlockOutlineListeners.add(listener);
    }

    public static void registerWorldRenderAfterLevel(WorldRenderContextListener listener) {
        worldRenderAfterLevelListeners.add(listener);
    }
}

