/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.pitan76.easyapi.config.Config;
import net.pitan76.mcpitanlib.api.command.CommandSettings;
import net.pitan76.mcpitanlib.api.command.LiteralCommand;
import net.pitan76.mcpitanlib.api.command.argument.StringCommand;
import net.pitan76.mcpitanlib.api.event.ServerCommandEvent;
import net.pitan76.mcpitanlib.api.event.StringCommandEvent;
import net.pitan76.mcpitanlib.api.util.TextUtil;
import org.jetbrains.annotations.Nullable;

public class ConfigCommand
extends LiteralCommand {
    public final Config config;
    public File file;
    public Supplier<Boolean> defaultConfigFunction;
    public String prefix = "[MCPitanLib]";

    public ConfigCommand(Config config, File file, String prefix) {
        this.config = config;
        this.file = file;
        this.prefix = prefix;
    }

    public ConfigCommand(Config config, File file, String prefix, @Nullable Supplier<Boolean> supplier) {
        this.config = config;
        this.file = file;
        this.defaultConfigFunction = supplier;
        this.prefix = prefix;
    }

    public ConfigCommand(Config config, File file, @Nullable Supplier<Boolean> supplier) {
        this.config = config;
        this.file = file;
        this.defaultConfigFunction = supplier;
    }

    public ConfigCommand(Config config, File file) {
        this.config = config;
        this.file = file;
    }

    public ConfigCommand(Config config) {
        this.config = config;
    }

    @Override
    public void init(CommandSettings settings) {
        settings.permissionLevel(3);
        this.addArgumentCommand("set", new LiteralCommand(){

            @Override
            public void init(CommandSettings settings) {
                this.addArgumentCommand("key", new StringCommand(){

                    @Override
                    public String getArgumentName() {
                        return "key";
                    }

                    @Override
                    public void init(CommandSettings settings) {
                        this.addArgumentCommand("value", new StringCommand(){

                            @Override
                            public String getArgumentName() {
                                return "value";
                            }

                            @Override
                            public void execute(StringCommandEvent event) {
                                String key = StringArgumentType.getString((CommandContext)event.context, (String)"key");
                                String value = StringArgumentType.getString((CommandContext)event.context, (String)"value");
                                if (ConfigCommand.this.config.get(key) == null) {
                                    event.sendFailure((Component)TextUtil.literal(ConfigCommand.this.prefix + " Key not found."));
                                    return;
                                }
                                if (ConfigCommand.this.config.get(key).getClass() == String.class) {
                                    ConfigCommand.this.config.setString(key, value);
                                    event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " Set " + key + " to " + value), false);
                                } else if (ConfigCommand.this.config.get(key).getClass() == Integer.class) {
                                    ConfigCommand.this.config.setInt(key, Integer.parseInt(value));
                                    event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " Set " + key + " to " + value), false);
                                } else if (ConfigCommand.this.config.get(key).getClass() == Double.class) {
                                    ConfigCommand.this.config.setDouble(key, Double.parseDouble(value));
                                    event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " Set " + key + " to " + value), false);
                                } else if (ConfigCommand.this.config.get(key).getClass() == Boolean.class) {
                                    ConfigCommand.this.config.setBoolean(key, Boolean.parseBoolean(value));
                                    event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " Set " + key + " to " + value), false);
                                } else {
                                    event.sendFailure((Component)TextUtil.literal(ConfigCommand.this.prefix + " Not supported type."));
                                }
                                if (ConfigCommand.this.file != null) {
                                    ConfigCommand.this.config.save(ConfigCommand.this.file);
                                }
                            }
                        });
                    }

                    @Override
                    public void execute(StringCommandEvent event) {
                    }
                });
            }

            @Override
            public void execute(ServerCommandEvent event) {
            }
        });
        this.addArgumentCommand("get", new LiteralCommand(){

            @Override
            public void init(CommandSettings settings) {
                this.addArgumentCommand("key", new StringCommand(){

                    @Override
                    public String getArgumentName() {
                        return "key";
                    }

                    @Override
                    public void execute(StringCommandEvent event) {
                        String key = StringArgumentType.getString((CommandContext)event.context, (String)"key");
                        if (ConfigCommand.this.config.get(key) == null) {
                            event.sendFailure((Component)TextUtil.literal(ConfigCommand.this.prefix + " Key not found."));
                            return;
                        }
                        event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " " + key + ": " + ConfigCommand.this.config.get(key).toString()), false);
                    }
                });
            }

            @Override
            public void execute(ServerCommandEvent event) {
            }
        });
        this.addArgumentCommand("list", new LiteralCommand(){

            @Override
            public void execute(ServerCommandEvent event) {
                event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " Config List"), false);
                for (String key : ConfigCommand.this.config.configMap.keySet()) {
                    event.sendSuccess((Component)TextUtil.literal(" - " + key + ": " + ConfigCommand.this.config.get(key).toString()), false);
                }
            }
        });
        if (this.defaultConfigFunction != null) {
            this.addArgumentCommand("reset", new LiteralCommand(){

                @Override
                public void execute(ServerCommandEvent event) {
                    ConfigCommand.this.config.configMap.clear();
                    ConfigCommand.this.defaultConfigFunction.get();
                    if (ConfigCommand.this.file != null) {
                        ConfigCommand.this.config.save(ConfigCommand.this.file);
                    }
                    event.sendSuccess((Component)TextUtil.literal(ConfigCommand.this.prefix + " Reset config."), false);
                }
            });
        }
    }

    @Override
    public void execute(ServerCommandEvent event) {
    }
}

