/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.pitan76.mcpitanlib.api.util.CompatIdentifier;

public class FluidUtil {
    public static ResourceLocation toID(Fluid fluid) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
    }

    public static Fluid fromId(ResourceLocation identifier) {
        return (Fluid)BuiltInRegistries.f_257020_.m_7745_(identifier);
    }

    public static Fluid fromId(CompatIdentifier identifier) {
        return FluidUtil.fromId(identifier.toMinecraft());
    }

    public static int getRawId(Fluid fluid) {
        return BuiltInRegistries.f_257020_.m_7447_((Object)fluid);
    }

    public static Fluid fromIndex(int index) {
        return (Fluid)BuiltInRegistries.f_257020_.m_7942_(index);
    }

    public static boolean isExist(CompatIdentifier id) {
        return BuiltInRegistries.f_257020_.m_7804_(id.toMinecraft());
    }

    public static CompatIdentifier toCompatId(Fluid fluid) {
        return CompatIdentifier.fromMinecraft(FluidUtil.toID(fluid));
    }

    public static Fluid fromCompatId(CompatIdentifier id) {
        return FluidUtil.fromId(id.toMinecraft());
    }

    public static FlowingFluid water() {
        return Fluids.f_76193_;
    }

    public static FlowingFluid lava() {
        return Fluids.f_76195_;
    }

    public static Fluid empty() {
        return Fluids.f_76191_;
    }

    public static FlowingFluid flowingWater() {
        return Fluids.f_76192_;
    }

    public static FlowingFluid flowingLava() {
        return Fluids.f_76194_;
    }

    public static boolean isStill(Fluid fluid) {
        return fluid == FluidUtil.water() || fluid == FluidUtil.lava();
    }

    public static boolean isStill(FluidState state) {
        return state.m_76170_();
    }

    public static FluidState getStill(FlowingFluid fluid, boolean falling) {
        return fluid.m_76068_(falling);
    }

    public static FluidState getFlowing(FlowingFluid fluid, int level, boolean falling) {
        return fluid.m_75953_(level, falling);
    }

    public static FluidState getStill(FlowingFluid fluid) {
        return FluidUtil.getStill(fluid, false);
    }

    public static FluidState getStillWater() {
        return FluidUtil.getStill(FluidUtil.water());
    }

    public static FluidState getStillLava() {
        return FluidUtil.getStill(FluidUtil.lava());
    }

    public static boolean isFlowing(Fluid fluid) {
        return fluid == FluidUtil.flowingWater() || fluid == FluidUtil.flowingLava();
    }

    public static int getTickRate(Fluid fluid, LevelReader world) {
        return fluid.m_6718_(world);
    }

    public static FluidState getDefaultState(Fluid fluid) {
        return fluid.m_76145_();
    }

    public static Item getBucketItem(Fluid fluid) {
        return fluid.m_6859_();
    }
}

