/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.pitan76.mcpitanlib.api.util.WorldUtil;

public class ItemEntityUtil {
    public static ItemEntity create(Level world, double x, double y, double z, ItemStack stack) {
        return new ItemEntity(world, x, y, z, stack);
    }

    public static ItemEntity create(Level world, BlockPos pos, ItemStack stack) {
        return ItemEntityUtil.create(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
    }

    public static ItemEntity create(Level world, Vec3 pos, ItemStack stack) {
        return ItemEntityUtil.create(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
    }

    public static ItemEntity create(Level world, double x, double y, double z, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        ItemEntity itemEntity = ItemEntityUtil.create(world, x, y, z, stack);
        ItemEntityUtil.setVelocity(itemEntity, velocityX, velocityY, velocityZ);
        return itemEntity;
    }

    public static void setVelocity(ItemEntity itemEntity, double velocityX, double velocityY, double velocityZ) {
        itemEntity.m_20334_(velocityX, velocityY, velocityZ);
    }

    public static void setVelocity(ItemEntity itemEntity, Vec3 vec3d) {
        itemEntity.m_20256_(vec3d);
    }

    public static void setPickupDelay(ItemEntity itemEntity, int pickupDelay) {
        itemEntity.m_32010_(pickupDelay);
    }

    public static void setToDefaultPickupDelay(ItemEntity itemEntity) {
        itemEntity.m_32060_();
    }

    public static ItemStack getStack(ItemEntity entity) {
        return entity.m_32055_();
    }

    public static List<ItemEntity> getEntities(Level world, AABB box) {
        return WorldUtil.getEntitiesByType(world, EntityType.f_20461_, box);
    }

    public static ItemEntity createWithSpawn(Level world, ItemStack stack, double x, double y, double z) {
        ItemEntity itemEntity = ItemEntityUtil.create(world, x, y, z, stack);
        ItemEntityUtil.setToDefaultPickupDelay(itemEntity);
        ItemEntityUtil.setVelocity(itemEntity, 0.0, 0.0, 0.0);
        WorldUtil.spawnEntity(world, (Entity)itemEntity);
        return itemEntity;
    }

    public static ItemEntity createWithSpawn(Level world, ItemStack stack, BlockPos pos) {
        return ItemEntityUtil.createWithSpawn(world, stack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }
}

