/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.recipe.input;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.pitan76.mcpitanlib.api.recipe.input.CompatRecipeInput;
import net.pitan76.mcpitanlib.api.util.ItemStackUtil;
import net.pitan76.mcpitanlib.api.util.collection.ItemStackList;
import net.pitan76.mcpitanlib.midohra.item.ItemStack;

public class CraftingRecipeInputUtil {
    public static Optional<TransientCraftingContainer> get(CompatRecipeInput<?> input) {
        if (input.getInput() instanceof TransientCraftingContainer) {
            return Optional.of((TransientCraftingContainer)input.getInput());
        }
        return Optional.empty();
    }

    public static CompatRecipeInput<?> create(TransientCraftingContainer input) {
        return new CompatRecipeInput<TransientCraftingContainer>(input);
    }

    public static CompatRecipeInput<?> create(int width, int height, List<net.minecraft.world.item.ItemStack> stacks) {
        ItemStackList stackList = ItemStackList.ofSize(stacks.size(), ItemStackUtil.empty());
        for (int i = 0; i < stacks.size(); ++i) {
            stackList.set(i, stacks.get(i));
        }
        return new CompatRecipeInput<TransientCraftingContainer>(new TransientCraftingContainer(null, width, height, (NonNullList)stackList));
    }

    public static net.minecraft.world.item.ItemStack getStack(TransientCraftingContainer input, int x, int y) {
        return input.m_8020_(x + y * input.m_39347_());
    }

    public static net.minecraft.world.item.ItemStack getStack(CompatRecipeInput<?> input, int x, int y) {
        Optional<TransientCraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return ItemStackUtil.empty();
        }
        return CraftingRecipeInputUtil.getStack(recipeInput.get(), x, y);
    }

    public static ItemStack getMidohraStack(CompatRecipeInput<?> input, int x, int y) {
        return ItemStack.of(CraftingRecipeInputUtil.getStack(input, x, y));
    }

    public static StackedContents getRecipeMatcher(TransientCraftingContainer input) {
        return null;
    }

    public static StackedContents getRecipeMatcher(CompatRecipeInput<?> input) {
        Optional<TransientCraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getRecipeMatcher(recipeInput.get());
    }

    public static List<net.minecraft.world.item.ItemStack> getStacks(TransientCraftingContainer input) {
        return input.m_280657_();
    }

    public static List<net.minecraft.world.item.ItemStack> getStacks(CompatRecipeInput<?> input) {
        Optional<TransientCraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return null;
        }
        return CraftingRecipeInputUtil.getStacks(recipeInput.get());
    }

    public static int getWidth(TransientCraftingContainer input) {
        return input.m_39347_();
    }

    public static int getWidth(CompatRecipeInput<?> input) {
        Optional<TransientCraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getWidth(recipeInput.get());
    }

    public static int getHeight(TransientCraftingContainer input) {
        return input.m_39346_();
    }

    public static int getHeight(CompatRecipeInput<?> input) {
        Optional<TransientCraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getHeight(recipeInput.get());
    }

    public static int getStackCount(TransientCraftingContainer input) {
        return input.m_280657_().size();
    }

    public static int getStackCount(CompatRecipeInput<?> input) {
        Optional<TransientCraftingContainer> recipeInput = CraftingRecipeInputUtil.get(input);
        if (!recipeInput.isPresent()) {
            return -1;
        }
        return CraftingRecipeInputUtil.getStackCount(recipeInput.get());
    }
}

