/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util.v2;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.pitan76.mcpitanlib.api.tag.TagKey;
import net.pitan76.mcpitanlib.api.util.BlockUtil;

public class BlockUtilV2 {
    public static boolean isIn(Block block, TagKey<Block> tagKey) {
        if (block.m_204297_().m_203656_(tagKey.getTagKey())) {
            return true;
        }
        return tagKey.isOf(block);
    }

    public static boolean isEqual(Block block, Block block2) {
        return block == block2;
    }

    public static List<Block> getBlocks(TagKey<Block> tagKey) {
        return BlockUtilV2.getBlocks(tagKey, BlockUtil.getAllBlocks());
    }

    public static List<Block> getBlocks(TagKey<Block> tagKey, List<Block> blocks) {
        ArrayList<Block> result = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!BlockUtil.isIn(block, tagKey)) continue;
            result.add(block);
        }
        return result;
    }

    public static List<Block> getBlocks(ResourceLocation identifier) {
        return BlockUtilV2.getBlocks(TagKey.create(TagKey.Type.BLOCK, identifier));
    }

    public static List<Block> getBlocks(ResourceLocation identifier, List<Block> blocks) {
        return BlockUtilV2.getBlocks(TagKey.create(TagKey.Type.BLOCK, identifier), blocks);
    }

    public static List<Block> getBlocks(String id) {
        return BlockUtilV2.getBlocks(new ResourceLocation(id));
    }

    public static List<Block> getBlocks(String id, List<Block> blocks) {
        return BlockUtilV2.getBlocks(new ResourceLocation(id), blocks);
    }

    public static boolean isBlockInTag(Block block, ResourceLocation identifier) {
        return BlockUtil.isIn(block, TagKey.create(TagKey.Type.BLOCK, identifier));
    }

    public static boolean isBlockInTag(Block block, String id) {
        return BlockUtilV2.isBlockInTag(block, new ResourceLocation(id));
    }

    public static Block fromItem(Item item) {
        return Block.m_49814_((Item)item);
    }

    public static Block fromItem(ItemStack stack) {
        return BlockUtilV2.fromItem(stack.m_41720_());
    }
}

