/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.extra.transfer.util;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_7225;
import net.pitan76.mcpitanlib.api.event.nbt.NbtRWArgs;
import net.pitan76.mcpitanlib.api.event.nbt.ReadNbtArgs;
import net.pitan76.mcpitanlib.api.event.nbt.WriteNbtArgs;
import net.pitan76.mcpitanlib.api.registry.CompatRegistryLookup;
import net.pitan76.mcpitanlib.core.mc1216.NbtDataConverter;

public class FluidStorageUtil {
    public static SingleFluidStorage withFixedCapacity(long capacity, Runnable onChange) {
        return SingleFluidStorage.withFixedCapacity((long)capacity, (Runnable)onChange);
    }

    public static void readNbt(SingleFluidStorage storage, NbtRWArgs args) {
        if (args instanceof ReadNbtArgs) {
            storage.readData(((ReadNbtArgs)args).view);
        }
    }

    public static void writeNbt(SingleFluidStorage storage, NbtRWArgs args) {
        if (args instanceof WriteNbtArgs) {
            storage.writeData(((WriteNbtArgs)args).view);
        }
    }

    public static void readNbt(SingleFluidStorage storage, class_2487 nbt, CompatRegistryLookup registryLookup) {
        storage.readData(NbtDataConverter.nbt2readData(nbt, registryLookup));
    }

    public static void writeNbt(SingleFluidStorage storage, class_2487 nbt, CompatRegistryLookup registryLookup) {
        storage.writeData(NbtDataConverter.nbt2writeData(nbt, registryLookup));
    }

    @Deprecated
    public static void readNbt(SingleFluidStorage storage, class_2487 nbt, class_1937 world) {
        FluidStorageUtil.readNbt(storage, nbt, new CompatRegistryLookup((class_7225.class_7874)world.method_30349()));
    }

    @Deprecated
    public static void writeNbt(SingleFluidStorage storage, class_2487 nbt, class_1937 world) {
        FluidStorageUtil.writeNbt(storage, nbt, new CompatRegistryLookup((class_7225.class_7874)world.method_30349()));
    }

    public static long getAmount(SingleFluidStorage storage) {
        return storage.getAmount();
    }

    public static long getCapacity(SingleFluidStorage storage) {
        return storage.getCapacity();
    }

    public static FluidVariant getResource(SingleFluidStorage storage) {
        return (FluidVariant)storage.getResource();
    }

    public static boolean isResourceBlank(SingleFluidStorage storage) {
        return storage.isResourceBlank();
    }

    public static long insert(SingleFluidStorage storage, FluidVariant insertedVariant, long maxAmount, Transaction transaction) {
        return storage.insert((TransferVariant)insertedVariant, maxAmount, (TransactionContext)transaction);
    }

    public static long extract(SingleFluidStorage storage, FluidVariant extractedVariant, long maxAmount, Transaction transaction) {
        return storage.extract((TransferVariant)extractedVariant, maxAmount, (TransactionContext)transaction);
    }

    public static void insert(SingleFluidStorage storage, class_3610 fluidState, long maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            FluidStorageUtil.insert(storage, FluidVariant.of((class_3611)fluidState.method_15772()), maxAmount, transaction);
            transaction.commit();
        }
    }

    public static void extract(SingleFluidStorage storage, class_3610 fluidState, long maxAmount) {
        try (Transaction transaction = Transaction.openOuter();){
            FluidStorageUtil.extract(storage, FluidVariant.of((class_3611)fluidState.method_15772()), maxAmount, transaction);
            transaction.commit();
        }
    }

    public static boolean isEmpty(SingleFluidStorage storage) {
        return FluidStorageUtil.getAmount(storage) == 0L;
    }

    public static boolean isFull(SingleFluidStorage storage) {
        return FluidStorageUtil.getAmount(storage) >= FluidStorageUtil.getCapacity(storage);
    }
}

